/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.descriptor;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import ognl.Ognl;
import ognl.OgnlException;
import org.apache.commons.beanutils.BeanUtils;
import org.tynamo.descriptor.Descriptor;
import org.tynamo.descriptor.IMethodDescriptor;
import org.tynamo.descriptor.TynamoClassDescriptor;
import org.tynamo.descriptor.TynamoDescriptor;
import org.tynamo.descriptor.TynamoPropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TynamoClassDescriptorImpl
extends TynamoDescriptor
implements TynamoClassDescriptor {
    private List<TynamoPropertyDescriptor> propertyDescriptors = new ArrayList<TynamoPropertyDescriptor>();
    private List<IMethodDescriptor> methodDescriptors = new ArrayList<IMethodDescriptor>();
    private boolean child;
    boolean hasCyclicRelationships;
    boolean allowRemove = true;
    boolean allowSave = true;

    public TynamoClassDescriptorImpl(TynamoClassDescriptor descriptor) {
        super(descriptor);
        this.copyPropertyDescriptorsFrom(descriptor);
        this.copyMethodDescriptorsFrom(descriptor);
    }

    public TynamoClassDescriptorImpl(Class type) {
        super(type);
    }

    public TynamoClassDescriptorImpl(TynamoClassDescriptorImpl dto) {
        super(dto);
        try {
            BeanUtils.copyProperties((Object)this, (Object)dto);
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)e.getMessage());
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            LOG.error((Object)e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            LOG.error((Object)e.toString());
            e.printStackTrace();
        }
    }

    private void copyMethodDescriptorsFrom(TynamoClassDescriptor descriptor) {
        for (IMethodDescriptor methodDescriptor : descriptor.getMethodDescriptors()) {
            this.getMethodDescriptors().add((IMethodDescriptor)IMethodDescriptor.class.cast(methodDescriptor.clone()));
        }
    }

    protected void copyPropertyDescriptorsFrom(TynamoClassDescriptor descriptor) {
        for (TynamoPropertyDescriptor iPropertyDescriptor : descriptor.getPropertyDescriptors()) {
            this.getPropertyDescriptors().add((TynamoPropertyDescriptor)TynamoPropertyDescriptor.class.cast(iPropertyDescriptor.clone()));
        }
    }

    private TynamoPropertyDescriptor findDescriptor(String ognl) {
        try {
            return (TynamoPropertyDescriptor)Ognl.getValue((String)ognl, (Object)this);
        }
        catch (OgnlException oe) {
            return null;
        }
        catch (IndexOutOfBoundsException ie) {
            return null;
        }
    }

    @Override
    public TynamoPropertyDescriptor getPropertyDescriptor(String name) {
        return this.findDescriptor("propertyDescriptors.{? name == '" + name + "'}[0]");
    }

    @Override
    public List<TynamoPropertyDescriptor> getPropertyDescriptors(List<String> properties) {
        ArrayList<TynamoPropertyDescriptor> descriptors = new ArrayList<TynamoPropertyDescriptor>();
        for (String property : properties) {
            descriptors.add(this.getPropertyDescriptor(property));
        }
        return descriptors;
    }

    @Override
    public List<IMethodDescriptor> getMethodDescriptors() {
        return this.methodDescriptors;
    }

    @Override
    public void setMethodDescriptors(List<IMethodDescriptor> methodDescriptors) {
        this.methodDescriptors = methodDescriptors;
    }

    @Override
    public List<TynamoPropertyDescriptor> getPropertyDescriptors() {
        return this.propertyDescriptors;
    }

    @Override
    public void setPropertyDescriptors(List<TynamoPropertyDescriptor> propertyDescriptors) {
        this.propertyDescriptors = propertyDescriptors;
    }

    @Override
    public TynamoPropertyDescriptor getIdentifierDescriptor() {
        String ognl = "propertyDescriptors.{? identifier}[0]";
        return this.findDescriptor(ognl);
    }

    @Override
    public boolean isChild() {
        return this.child;
    }

    @Override
    public void setChild(boolean child) {
        this.child = child;
    }

    @Override
    public Object clone() {
        return new TynamoClassDescriptorImpl(this);
    }

    @Override
    public void copyFrom(Descriptor descriptor) {
        super.copyFrom(descriptor);
        if (descriptor instanceof TynamoClassDescriptorImpl) {
            try {
                BeanUtils.copyProperties((Object)this, (Object)((TynamoClassDescriptorImpl)descriptor));
                this.copyPropertyDescriptorsFrom((TynamoClassDescriptorImpl)descriptor);
                this.copyMethodDescriptorsFrom((TynamoClassDescriptorImpl)descriptor);
            }
            catch (IllegalAccessException e) {
                LOG.error((Object)e.getMessage());
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                LOG.error((Object)e.getMessage());
                e.printStackTrace();
            }
            catch (Exception e) {
                LOG.error((Object)e.toString());
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean isAllowRemove() {
        return this.allowRemove;
    }

    @Override
    public void setAllowRemove(boolean allowRemove) {
        this.allowRemove = allowRemove;
    }

    @Override
    public boolean isAllowSave() {
        return this.allowSave;
    }

    @Override
    public void setAllowSave(boolean allowSave) {
        this.allowSave = allowSave;
    }

    @Override
    public boolean getHasCyclicRelationships() {
        return this.hasCyclicRelationships;
    }

    @Override
    public void setHasCyclicRelationships(boolean hasBidirectionalRelationship) {
        this.hasCyclicRelationships = hasBidirectionalRelationship;
    }

    public String toString() {
        return "{TynamoClassDescriptor - Type: " + this.getType() + "}";
    }
}

