/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.descriptor;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tynamo.descriptor.Descriptor;
import org.tynamo.descriptor.DescriptorExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TynamoDescriptor
implements Descriptor,
Serializable {
    protected static final Log LOG = LogFactory.getLog(TynamoDescriptor.class);
    protected Class type;
    private boolean hidden;
    Map<String, DescriptorExtension> extensions = new Hashtable<String, DescriptorExtension>();

    public TynamoDescriptor(TynamoDescriptor dto) {
        try {
            BeanUtils.copyProperties((Object)this, (Object)dto);
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)e.getMessage());
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            LOG.error((Object)e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            LOG.error((Object)e.toString());
            e.printStackTrace();
        }
    }

    public TynamoDescriptor(Descriptor descriptor) {
        try {
            BeanUtils.copyProperties((Object)this, (Object)descriptor);
            this.copyExtensionsFrom(descriptor);
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)e.getMessage());
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            LOG.error((Object)e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            LOG.error((Object)e.toString());
            e.printStackTrace();
        }
    }

    public TynamoDescriptor(Class type) {
        this.type = type;
    }

    @Override
    public Object clone() {
        return new TynamoDescriptor(this);
    }

    public void copyFrom(Descriptor descriptor) {
        try {
            BeanUtils.copyProperties((Object)this, (Object)descriptor);
            this.copyExtensionsFrom(descriptor);
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)e.getMessage());
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            LOG.error((Object)e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            LOG.error((Object)e.toString());
            e.printStackTrace();
        }
    }

    public void copyExtensionsFrom(Descriptor descriptor) {
        Map<String, DescriptorExtension> exts = descriptor.getExtensions();
        for (Map.Entry<String, DescriptorExtension> entry : exts.entrySet()) {
            String keye = entry.getKey();
            DescriptorExtension value = entry.getValue();
            try {
                this.addExtension(keye, (DescriptorExtension)BeanUtils.cloneBean((Object)value));
            }
            catch (Exception e) {}
        }
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public Class getType() {
        return this.type;
    }

    public void setType(Class type) {
        this.type = type;
    }

    @Override
    public boolean supportsExtension(String keye) {
        return this.getExtension(keye) != null;
    }

    @Override
    public boolean supportsExtension(Class extensionType) {
        return this.supportsExtension(extensionType.getName());
    }

    @Override
    public DescriptorExtension getExtension(String keye) {
        return this.extensions.get(keye);
    }

    @Override
    public void addExtension(String keye, DescriptorExtension extension) {
        this.extensions.put(keye, extension);
    }

    @Override
    public void addExtension(Class extensionType, DescriptorExtension extension) {
        this.addExtension(extensionType.getName(), extension);
    }

    @Override
    public void removeExtension(String keye) {
        this.extensions.remove(keye);
    }

    @Override
    public void removeExtension(Class extensionType) {
        this.removeExtension(extensionType.getName());
    }

    @Override
    public <E extends DescriptorExtension> E getExtension(Class<E> extensionType) {
        return (E)this.extensions.get(extensionType.getName());
    }

    @Override
    public Map<String, DescriptorExtension> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(Map<String, DescriptorExtension> extensions) {
        this.extensions = extensions;
    }
}

