/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.blob;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.services.PageRenderLinkSource;
import org.apache.tapestry5.upload.services.UploadedFile;
import org.tynamo.blob.BlobManager;
import org.tynamo.blob.TynamoBlobImpl;
import org.tynamo.descriptor.TynamoPropertyDescriptor;
import org.tynamo.descriptor.extension.BlobDescriptorExtension;
import org.tynamo.descriptor.extension.TynamoBlob;
import org.tynamo.services.PersistenceService;

public class DefaultBlobManager
implements BlobManager {
    private PersistenceService persistenceService;
    private PropertyAccess propertyAccess;
    private PageRenderLinkSource pageRenderLinkSource;

    public DefaultBlobManager(PersistenceService persistenceService, PropertyAccess propertyAccess, PageRenderLinkSource pageRenderLinkSource) {
        this.persistenceService = persistenceService;
        this.propertyAccess = propertyAccess;
        this.pageRenderLinkSource = pageRenderLinkSource;
    }

    public void store(TynamoPropertyDescriptor propertyDescriptor, Object model, UploadedFile file) {
        BlobDescriptorExtension blobDescriptorExtension = this.getBlobDescriptorExtension(propertyDescriptor);
        byte[] data = new byte[]{};
        InputStream inputStream = file.getStream();
        try {
            data = IOUtils.toByteArray((InputStream)inputStream);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        if (data.length > 1) {
            if (blobDescriptorExtension.isBytes()) {
                this.propertyAccess.set(model, propertyDescriptor.getName(), (Object)data);
            } else if (blobDescriptorExtension.isITynamoBlob()) {
                TynamoBlob trailsBlob = (TynamoBlob)this.propertyAccess.get(model, propertyDescriptor.getName());
                if (trailsBlob == null) {
                    trailsBlob = new TynamoBlobImpl();
                    this.propertyAccess.set(model, propertyDescriptor.getName(), (Object)trailsBlob);
                }
                trailsBlob.setFileName(file.getFileName());
                trailsBlob.setFilePath(file.getFilePath());
                trailsBlob.setContentType(file.getContentType());
                trailsBlob.setBytes(data);
            }
        }
    }

    public byte[] getData(TynamoPropertyDescriptor propertyDescriptor, Object model) {
        BlobDescriptorExtension blobDescriptorExtension = this.getBlobDescriptorExtension(propertyDescriptor);
        if (blobDescriptorExtension.isBytes()) {
            return (byte[])this.propertyAccess.get(model, propertyDescriptor.getName());
        }
        if (blobDescriptorExtension.isITynamoBlob()) {
            TynamoBlob trailsBlob = (TynamoBlob)this.propertyAccess.get(model, propertyDescriptor.getName());
            return trailsBlob != null ? trailsBlob.getBytes() : new byte[]{};
        }
        return null;
    }

    public void delete(TynamoPropertyDescriptor propertyDescriptor, Object model) {
        BlobDescriptorExtension blobDescriptorExtension = this.getBlobDescriptorExtension(propertyDescriptor);
        if (blobDescriptorExtension.isBytes()) {
            this.propertyAccess.set(model, propertyDescriptor.getName(), (Object)new byte[0]);
        } else if (blobDescriptorExtension.isITynamoBlob()) {
            TynamoBlob trailsBlob = (TynamoBlob)this.propertyAccess.get(model, propertyDescriptor.getName());
            trailsBlob.reset();
        }
        this.persistenceService.save(model);
    }

    public Link createBlobLink(TynamoPropertyDescriptor propertyDescriptor, Object model) {
        return this.pageRenderLinkSource.createPageRenderLinkWithContext("tynamo/Blob", new Object[]{propertyDescriptor.getBeanType(), model, propertyDescriptor.getName()});
    }

    public String getContentType(TynamoPropertyDescriptor propertyDescriptor, Object model) {
        TynamoBlob trailsBlob;
        BlobDescriptorExtension blobDescriptorExtension = this.getBlobDescriptorExtension(propertyDescriptor);
        if (StringUtils.isNotEmpty((String)blobDescriptorExtension.getFileName())) {
            return blobDescriptorExtension.getContentType();
        }
        if (blobDescriptorExtension.isITynamoBlob() && (trailsBlob = (TynamoBlob)this.propertyAccess.get(model, propertyDescriptor.getName())) != null) {
            return trailsBlob.getContentType();
        }
        return null;
    }

    public String getFileName(TynamoPropertyDescriptor propertyDescriptor, Object model) {
        TynamoBlob trailsBlob;
        BlobDescriptorExtension blobDescriptorExtension = this.getBlobDescriptorExtension(propertyDescriptor);
        if (StringUtils.isNotEmpty((String)blobDescriptorExtension.getFileName())) {
            return blobDescriptorExtension.getFileName();
        }
        if (blobDescriptorExtension.isITynamoBlob() && (trailsBlob = (TynamoBlob)this.propertyAccess.get(model, propertyDescriptor.getName())) != null) {
            return trailsBlob.getFileName();
        }
        return null;
    }

    public boolean isNotNull(TynamoPropertyDescriptor propertyDescriptor, Object model) {
        BlobDescriptorExtension blobDescriptorExtension = this.getBlobDescriptorExtension(propertyDescriptor);
        TynamoBlob trailsBlob = (TynamoBlob)this.propertyAccess.get(model, propertyDescriptor.getName());
        return trailsBlob != null && trailsBlob.getBytes() != null && trailsBlob.getBytes().length > 0;
    }

    private BlobDescriptorExtension getBlobDescriptorExtension(TynamoPropertyDescriptor propertyDescriptor) {
        return propertyDescriptor.getExtension(BlobDescriptorExtension.class);
    }
}

