/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.components;

import org.apache.tapestry5.Asset;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.tynamo.FlashMessage;

public class Flash {
    @Property
    @Persist(value="flash")
    private FlashMessage message;
    @Inject
    private Messages messages;
    @Parameter(value="asset:icon_success_sml.gif")
    @Property(write=false)
    private Asset iconInformation;
    @Parameter(value="asset:icon_warning_sml.gif")
    @Property(write=false)
    private Asset iconWarning;

    final boolean beginRender(MarkupWriter writer) {
        if (this.message == null || "".equals(this.message.getMessage())) {
            return false;
        }
        String clientId = "successMessages";
        String className = "message";
        Asset icon = this.iconInformation;
        String altName = this.messages.get("icon.information");
        if (this.message.getType() == FlashMessage.MessageType.FAILURE) {
            clientId = "errorMessages";
            className = "error";
            altName = this.messages.get("icon.warning");
            icon = this.iconWarning;
        }
        writer.element("div", new Object[]{"id", clientId, "class", className});
        writer.element("img", new Object[]{"src", icon.toClientURL(), "alt", altName, "class", "icon"});
        writer.write(this.message.getMessage());
        writer.end();
        writer.end();
        return false;
    }

    public void addFlashByKey(String key, FlashMessage.MessageType type, Object ... args) {
        this.message = new FlashMessage(this.messages.format(key, args), type);
    }

    public void addFlash(String message, FlashMessage.MessageType type) {
        this.message = new FlashMessage(message, type);
    }
}

