/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.descriptor.annotation;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import ognl.Ognl;
import org.tynamo.descriptor.Descriptor;
import org.tynamo.descriptor.DescriptorDecorator;
import org.tynamo.descriptor.DescriptorExtension;
import org.tynamo.descriptor.EmbeddedDescriptor;
import org.tynamo.descriptor.TynamoClassDescriptor;
import org.tynamo.descriptor.TynamoPropertyDescriptor;
import org.tynamo.descriptor.annotation.ExpressionExtension;
import org.tynamo.descriptor.annotation.InitialValue;
import org.tynamo.descriptor.annotation.InitialValueDescriptorExtension;
import org.tynamo.descriptor.annotation.PossibleValues;
import org.tynamo.descriptor.annotation.PossibleValuesDescriptorExtension;

public class OgnlAnnotationsDecorator
implements DescriptorDecorator {
    private Map context;

    public TynamoClassDescriptor decorate(TynamoClassDescriptor descriptor) {
        this.decoratePropertyDescriptors(descriptor);
        return descriptor;
    }

    private void decoratePropertyDescriptors(TynamoClassDescriptor descriptor) {
        for (TynamoPropertyDescriptor propertyDescriptor : descriptor.getPropertyDescriptors()) {
            this.decoratePropertyDescriptor(propertyDescriptor);
            if (!propertyDescriptor.isEmbedded()) continue;
            this.decorate((EmbeddedDescriptor)propertyDescriptor);
        }
    }

    private void decoratePropertyDescriptor(TynamoPropertyDescriptor propertyDescriptor) {
        try {
            Field propertyField = propertyDescriptor.getBeanType().getDeclaredField(propertyDescriptor.getName());
            this.decorateFromAnnotations(propertyDescriptor, propertyField.getAnnotations());
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            PropertyDescriptor beanPropDescriptor = (PropertyDescriptor)Ognl.getValue((String)("propertyDescriptors.{? name == '" + propertyDescriptor.getName() + "'}[0]"), (Object)Introspector.getBeanInfo(propertyDescriptor.getBeanType()));
            Method readMethod = beanPropDescriptor.getReadMethod();
            this.decorateFromAnnotations(propertyDescriptor, readMethod.getAnnotations());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void decorateFromAnnotations(Descriptor descriptor, Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            ExpressionExtension extension;
            if (annotation instanceof InitialValue) {
                extension = new InitialValueDescriptorExtension(((InitialValue)annotation).value(), this.context);
                descriptor.addExtension(InitialValueDescriptorExtension.class.getName(), (DescriptorExtension)extension);
                continue;
            }
            if (!(annotation instanceof PossibleValues)) continue;
            extension = new PossibleValuesDescriptorExtension(((PossibleValues)annotation).value(), this.context);
            descriptor.addExtension(PossibleValuesDescriptorExtension.class.getName(), (DescriptorExtension)extension);
        }
    }

    public void setContext(Map context) {
        this.context = context;
    }
}

