/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.services;

import java.util.List;
import ognl.Ognl;
import ognl.OgnlException;
import org.apache.tapestry5.beaneditor.DataType;
import org.apache.tapestry5.ioc.services.PropertyAdapter;
import org.apache.tapestry5.services.DataTypeAnalyzer;
import org.slf4j.Logger;
import org.tynamo.descriptor.TynamoClassDescriptor;
import org.tynamo.descriptor.TynamoPropertyDescriptor;
import org.tynamo.services.DescriptorService;
import org.tynamo.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TynamoDataTypeAnalyzer
implements DataTypeAnalyzer {
    private final DescriptorService descriptorService;
    private final List<Pair> editorMap;
    private final Logger logger;

    public TynamoDataTypeAnalyzer(DescriptorService descriptorService, List<Pair> editorMap, Logger logger) {
        this.descriptorService = descriptorService;
        this.editorMap = editorMap;
        this.logger = logger;
    }

    public String identifyDataType(PropertyAdapter adapter) {
        TynamoPropertyDescriptor propertyDescriptor;
        if (adapter.getAnnotation(DataType.class) == null && (propertyDescriptor = this.getPropertyDescriptor(adapter)) != null) {
            for (Pair entry : this.editorMap) {
                try {
                    if (!((Boolean)Ognl.getValue((String)((String)entry.getKey()), (Object)propertyDescriptor)).booleanValue()) continue;
                    return (String)entry.getValue();
                }
                catch (OgnlException oe) {
                    this.logger.error(String.format("Error evaluating expression: \"%s\" for the \"%s\" property of %s", entry.getKey(), adapter.getName(), adapter.getBeanType().getName()), (Throwable)oe);
                }
            }
        }
        return null;
    }

    private TynamoPropertyDescriptor getPropertyDescriptor(PropertyAdapter adapter) {
        TynamoClassDescriptor classDescriptor = this.descriptorService.getClassDescriptor(adapter.getBeanType());
        TynamoPropertyDescriptor propertyDescriptor = null;
        if (classDescriptor != null) {
            propertyDescriptor = classDescriptor.getPropertyDescriptor(adapter.getName());
        }
        return propertyDescriptor;
    }
}

