/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.util;

import org.apache.tapestry5.internal.TapestryInternalUtils;
import org.apache.tapestry5.ioc.Messages;
import org.tynamo.descriptor.TynamoClassDescriptor;
import org.tynamo.descriptor.TynamoPropertyDescriptor;
import org.tynamo.util.Utils;

public class DisplayNameUtils {
    private static final String PLURAL_SUFIX = "-plural";
    private static final String SHORTDESC_SUFIX = "-shortDescription";

    public static String getPluralDisplayName(TynamoClassDescriptor classDescriptor, Messages messages) {
        String fullName = classDescriptor.getType().getName() + PLURAL_SUFIX;
        String shortName = classDescriptor.getType().getSimpleName() + PLURAL_SUFIX;
        return DisplayNameUtils.selectDisplayName(fullName, shortName, Utils.pluralize(TapestryInternalUtils.toUserPresentable((String)classDescriptor.getType().getSimpleName())), messages);
    }

    public static String getDisplayName(TynamoClassDescriptor classDescriptor, Messages messages) {
        return DisplayNameUtils.getDisplayName(classDescriptor.getType(), messages);
    }

    public static String getDisplayName(Class type, Messages messages) {
        String fullName = type.getName();
        String shortName = type.getSimpleName();
        return DisplayNameUtils.selectDisplayName(fullName, shortName, TapestryInternalUtils.toUserPresentable((String)shortName), messages);
    }

    public static String getDisplayName(TynamoPropertyDescriptor propertyDescriptor, Messages messages) {
        return TapestryInternalUtils.defaultLabel((String)propertyDescriptor.getName(), (Messages)messages, (String)propertyDescriptor.getName());
    }

    public static String getShortDescription(TynamoClassDescriptor classDescriptor, Messages messages) {
        String fullName = classDescriptor.getType().getName() + SHORTDESC_SUFIX;
        String shortName = classDescriptor.getType().getSimpleName() + SHORTDESC_SUFIX;
        return DisplayNameUtils.selectDisplayName(fullName, shortName, "", messages);
    }

    public static String getShortDescription(TynamoPropertyDescriptor propertyDescriptor, Messages messages) {
        String fullName = propertyDescriptor.getBeanType().getName() + "." + propertyDescriptor.getName() + SHORTDESC_SUFIX;
        String shortName = propertyDescriptor.getName() + SHORTDESC_SUFIX;
        return DisplayNameUtils.selectDisplayName(fullName, shortName, "", messages);
    }

    private static String selectDisplayName(String firstKey, String secondKey, String defValue, Messages messages) {
        if (messages.contains(firstKey)) {
            return messages.get(firstKey);
        }
        if (messages.contains(secondKey)) {
            return messages.get(secondKey);
        }
        return defValue;
    }
}

