/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.descriptor.decorators;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import ognl.Ognl;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tynamo.descriptor.Descriptor;
import org.tynamo.descriptor.EmbeddedDescriptor;
import org.tynamo.descriptor.IMethodDescriptor;
import org.tynamo.descriptor.TynamoClassDescriptor;
import org.tynamo.descriptor.TynamoPropertyDescriptor;
import org.tynamo.descriptor.annotation.handlers.DescriptorAnnotationHandler;
import org.tynamo.descriptor.annotation.handlers.HandledBy;
import org.tynamo.descriptor.decorators.DescriptorDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TynamoDecorator
implements DescriptorDecorator {
    private static final Logger LOGGER = LoggerFactory.getLogger(TynamoDecorator.class);

    @Override
    public TynamoClassDescriptor decorate(TynamoClassDescriptor descriptor) {
        Annotation[] classAnnotations = descriptor.getBeanType().getAnnotations();
        TynamoClassDescriptor decoratedDescriptor = (TynamoClassDescriptor)this.decorateFromAnnotations(descriptor, classAnnotations);
        decoratedDescriptor.setPropertyDescriptors(this.decoratePropertyDescriptors(descriptor));
        decoratedDescriptor.setMethodDescriptors(this.decorateMethodDescriptors(descriptor));
        return decoratedDescriptor;
    }

    private List<TynamoPropertyDescriptor> decoratePropertyDescriptors(TynamoClassDescriptor descriptor) {
        ArrayList<TynamoPropertyDescriptor> decoratedPropertyDescriptors = new ArrayList<TynamoPropertyDescriptor>();
        for (TynamoPropertyDescriptor propertyDescriptor : descriptor.getPropertyDescriptors()) {
            TynamoPropertyDescriptor clonedDescriptor = this.decoratePropertyDescriptor(propertyDescriptor);
            if (clonedDescriptor.isEmbedded()) {
                clonedDescriptor = (EmbeddedDescriptor)this.decorate((EmbeddedDescriptor)clonedDescriptor);
            }
            decoratedPropertyDescriptors.add(clonedDescriptor);
        }
        return decoratedPropertyDescriptors;
    }

    private List<IMethodDescriptor> decorateMethodDescriptors(TynamoClassDescriptor descriptor) {
        ArrayList<IMethodDescriptor> decoratedMethodDescriptors = new ArrayList<IMethodDescriptor>();
        for (IMethodDescriptor methodDescriptor : descriptor.getMethodDescriptors()) {
            IMethodDescriptor clonedDescriptor = this.decorateMethodDescriptor(methodDescriptor);
            decoratedMethodDescriptors.add(clonedDescriptor);
        }
        return decoratedMethodDescriptors;
    }

    protected TynamoPropertyDescriptor decoratePropertyDescriptor(TynamoPropertyDescriptor propertyDescriptor) {
        TynamoPropertyDescriptor clonedDescriptor = (TynamoPropertyDescriptor)propertyDescriptor.clone();
        try {
            Field propertyField = clonedDescriptor.getBeanType().getDeclaredField(propertyDescriptor.getName());
            clonedDescriptor = (TynamoPropertyDescriptor)this.decorateFromAnnotations(clonedDescriptor, propertyField.getAnnotations());
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            PropertyDescriptor beanPropDescriptor = (PropertyDescriptor)Ognl.getValue((String)("propertyDescriptors.{? name == '" + propertyDescriptor.getName() + "'}[0]"), (Object)Introspector.getBeanInfo(clonedDescriptor.getBeanType()));
            Method readMethod = beanPropDescriptor.getReadMethod();
            clonedDescriptor = (TynamoPropertyDescriptor)this.decorateFromAnnotations(clonedDescriptor, readMethod.getAnnotations());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return clonedDescriptor;
    }

    protected IMethodDescriptor decorateMethodDescriptor(IMethodDescriptor methodDescriptor) {
        try {
            return (IMethodDescriptor)this.decorateFromAnnotations(methodDescriptor, methodDescriptor.getMethod().getAnnotations());
        }
        catch (NoSuchMethodException nsme) {
            LOGGER.warn(ExceptionUtils.getRootCauseMessage((Throwable)nsme));
            return methodDescriptor;
        }
    }

    private Descriptor decorateFromAnnotations(Descriptor descriptor, Annotation[] annotations) {
        Descriptor clonedDescriptor = (Descriptor)descriptor.clone();
        for (Annotation annotation : annotations) {
            HandledBy handlerAnnotation = annotation.annotationType().getAnnotation(HandledBy.class);
            if (handlerAnnotation == null) continue;
            try {
                DescriptorAnnotationHandler handler = handlerAnnotation.value().newInstance();
                clonedDescriptor = handler.decorateFromAnnotation(annotation, clonedDescriptor);
            }
            catch (Exception ex) {
                LOGGER.warn(ExceptionUtils.getRootCauseMessage((Throwable)ex));
            }
        }
        return clonedDescriptor;
    }
}

