/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.descriptor.extension;

import java.util.Map;
import ognl.Ognl;
import ognl.OgnlException;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tynamo.descriptor.extension.DescriptorExtension;
import org.tynamo.descriptor.extension.PossibleValuesDescriptorExtension;

public abstract class ExpressionExtension
implements DescriptorExtension {
    private static Log LOG = LogFactory.getLog(PossibleValuesDescriptorExtension.class);
    private String expression;
    private Map context;

    public ExpressionExtension(String theExpression) {
        Validate.notNull((Object)theExpression, (String)"The expression cannot be null");
        this.expression = theExpression;
    }

    public ExpressionExtension(String theExpression, Map context) {
        this(theExpression);
        this.context = context;
    }

    public Object evaluateExpresion(Object model) throws OgnlException {
        Validate.notNull((Object)model, (String)"The model cannot be null");
        try {
            if (this.context != null) {
                return Ognl.getValue((String)this.expression, (Map)this.context, (Object)model);
            }
            return Ognl.getValue((String)this.expression, (Object)model);
        }
        catch (OgnlException e) {
            LOG.warn((Object)("Exception thrown evaluationg " + this.expression), (Throwable)e);
            throw e;
        }
    }
}

