/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.builder;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.tynamo.builder.Builder;
import org.tynamo.exception.TynamoRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuilderDirector {
    private final Logger logger;
    Map<Class, Builder> builders;

    public BuilderDirector(Logger logger) {
        this.logger = logger;
        this.builders = new HashMap<Class, Builder>();
    }

    public BuilderDirector(Logger logger, Map<Class, Builder> builders) {
        this.logger = logger;
        this.builders = builders;
    }

    public <T> T createNewInstance(Class<T> type) {
        Builder builder = this.builders.get(type);
        if (builder != null) {
            return builder.build();
        }
        return this.createNewInstanceFromEmptyConstructor(type);
    }

    private <T> T createNewInstanceFromEmptyConstructor(Class<T> type) {
        try {
            Constructor<T> constructor = type.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception ex) {
            this.logger.error(String.format("Can't create an instance of %s using an empty constructor.", type));
            throw new TynamoRuntimeException(ex, type);
        }
    }
}

