/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.pages;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tapestry5.StreamResponse;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.ContextValueEncoder;
import org.apache.tapestry5.services.Response;
import org.tynamo.blob.BlobManager;
import org.tynamo.descriptor.TynamoPropertyDescriptor;
import org.tynamo.descriptor.extension.BlobDescriptorExtension;
import org.tynamo.services.DescriptorService;

public class Blob {
    @Inject
    private BlobManager filePersister;
    @Inject
    private DescriptorService descriptorService;
    @Inject
    private ContextValueEncoder contextValueEncoder;

    protected StreamResponse onActivate(Class clazz, String id, String property) throws Exception {
        final Object bean = this.contextValueEncoder.toValue(clazz, id);
        final TynamoPropertyDescriptor propertyDescriptor = this.descriptorService.getClassDescriptor(clazz).getPropertyDescriptor(property);
        return new StreamResponse(){

            public String getContentType() {
                return Blob.this.filePersister.getContentType(propertyDescriptor, bean);
            }

            public InputStream getStream() throws IOException {
                return new ByteArrayInputStream(Blob.this.filePersister.getData(propertyDescriptor, bean));
            }

            public void prepareResponse(Response response) {
                String contentDisposition = propertyDescriptor.getExtension(BlobDescriptorExtension.class).getContentDisposition().getValue();
                String fileName = Blob.this.filePersister.getFileName(propertyDescriptor, bean);
                response.setHeader("Content-Disposition", contentDisposition + (fileName != null ? "; filename=" + fileName : ""));
            }
        };
    }
}

