/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.services;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.util.StrategyRegistry;
import org.tynamo.descriptor.CollectionDescriptor;
import org.tynamo.descriptor.TynamoClassDescriptor;
import org.tynamo.descriptor.TynamoPropertyDescriptor;
import org.tynamo.descriptor.factories.DescriptorFactory;
import org.tynamo.services.DescriptorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescriptorServiceImpl
implements DescriptorService {
    private final StrategyRegistry<TynamoClassDescriptor> descriptorsRegistry;
    private final List<TynamoClassDescriptor> descriptors;

    public DescriptorServiceImpl(Collection<Class> types, DescriptorFactory descriptorFactory) {
        HashMap<Class, TynamoClassDescriptor> descriptorsMap = new HashMap<Class, TynamoClassDescriptor>();
        for (Class type : types) {
            descriptorsMap.put(type, descriptorFactory.buildClassDescriptor(type));
        }
        this.descriptors = CollectionFactory.newList(descriptorsMap.values());
        this.descriptorsRegistry = StrategyRegistry.newInstance(TynamoClassDescriptor.class, descriptorsMap, (boolean)true);
        for (TynamoClassDescriptor classDescriptor : descriptorsMap.values()) {
            this.findChildren(classDescriptor);
        }
    }

    @Override
    public List<TynamoClassDescriptor> getAllDescriptors() {
        return this.descriptors;
    }

    @Override
    public TynamoClassDescriptor getClassDescriptor(Class type) {
        return (TynamoClassDescriptor)this.descriptorsRegistry.get(type);
    }

    private void findChildren(TynamoClassDescriptor classDescriptor) {
        for (TynamoPropertyDescriptor propertyDescriptor : classDescriptor.getPropertyDescriptors()) {
            if (!propertyDescriptor.isCollection()) continue;
            if (((CollectionDescriptor)propertyDescriptor).isChildRelationship()) {
                TynamoClassDescriptor collectionClassDescriptor = this.getClassDescriptor(((CollectionDescriptor)propertyDescriptor).getElementType());
                collectionClassDescriptor.setChild(true);
            }
            if (((CollectionDescriptor)propertyDescriptor).getInverseProperty() == null) continue;
            classDescriptor.setHasCyclicRelationships(true);
        }
    }
}

