/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.base;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.queryParser.MultiFieldQueryParser;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Version;
import org.apache.tapestry5.grid.GridDataSource;
import org.tynamo.base.GenericModelSearch;
import org.tynamo.descriptor.TynamoClassDescriptor;
import org.tynamo.descriptor.TynamoPropertyDescriptor;
import org.tynamo.search.SearchFilterPredicate;

public abstract class GenericLuceneModelSearch
extends GenericModelSearch {
    public GridDataSource getGridDataSource() {
        Map<TynamoPropertyDescriptor, SearchFilterPredicate> propertySearchFilterMap = this.getActiveFilterMap();
        if (this.getSearchTerms() == null) {
            return this.createGridDataSource();
        }
        TynamoClassDescriptor classDescriptor = this.getDescriptorService().getClassDescriptor(this.getBeanType());
        ArrayList<String> fieldNames = new ArrayList<String>();
        List<TynamoPropertyDescriptor> propertyDescriptors = classDescriptor.getPropertyDescriptors();
        for (TynamoPropertyDescriptor propertyDescriptor : propertyDescriptors) {
            if (!propertyDescriptor.isSearchable() || !propertyDescriptor.isString()) continue;
            fieldNames.add(propertyDescriptor.getName());
        }
        if (fieldNames.size() <= 0) {
            return this.createGridDataSource();
        }
        MultiFieldQueryParser parser = new MultiFieldQueryParser(Version.LUCENE_36, fieldNames.toArray(new String[0]), (Analyzer)new StandardAnalyzer(Version.LUCENE_36));
        try {
            return this.createGridDataSource(parser.parse(this.getSearchTerms()));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract GridDataSource createGridDataSource();

    protected abstract GridDataSource createGridDataSource(Query var1);
}

