/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.descriptor.extension;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tynamo.blob.ContentDisposition;
import org.tynamo.blob.RenderType;
import org.tynamo.descriptor.extension.DescriptorExtension;
import org.tynamo.descriptor.extension.TynamoBlob;
import org.tynamo.exception.TynamoRuntimeException;

public class BlobDescriptorExtension
implements DescriptorExtension {
    protected static final Log LOG = LogFactory.getLog(BlobDescriptorExtension.class);
    private BlobType blobType = BlobType.BYTES;
    private String fileName = "";
    private String contentType = "";
    private ContentDisposition contentDisposition = ContentDisposition.INLINE;
    private RenderType renderType = RenderType.LINK;

    public BlobDescriptorExtension(Class beanType) {
        if (TynamoBlob.class.isAssignableFrom(beanType)) {
            this.blobType = BlobType.TYNAMO_BLOB;
        } else if (beanType.isArray()) {
            this.blobType = BlobType.BYTES;
        } else {
            throw new TynamoRuntimeException("type: " + beanType + " - Not supported");
        }
    }

    public boolean isBytes() {
        return this.blobType == BlobType.BYTES;
    }

    public boolean isITynamoBlob() {
        return this.blobType == BlobType.TYNAMO_BLOB;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public RenderType getRenderType() {
        return this.renderType;
    }

    public void setRenderType(RenderType renderType) {
        this.renderType = renderType;
    }

    public ContentDisposition getContentDisposition() {
        return this.contentDisposition;
    }

    public void setContentDisposition(ContentDisposition contentDisposition) {
        this.contentDisposition = contentDisposition;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum BlobType {
        BYTES,
        TYNAMO_BLOB;

    }
}

