/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.descriptor;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tynamo.descriptor.Descriptor;
import org.tynamo.descriptor.extension.DescriptorExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TynamoDescriptor
implements Descriptor,
Serializable {
    protected static final Logger logger = LoggerFactory.getLogger(TynamoDescriptor.class);
    protected Class beanType;
    private boolean nonVisual;
    Map<String, DescriptorExtension> extensions = new Hashtable<String, DescriptorExtension>();

    public TynamoDescriptor(TynamoDescriptor dto) {
        try {
            BeanUtils.copyProperties((Object)this, (Object)dto);
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage());
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            logger.error(e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            logger.error(e.toString());
            e.printStackTrace();
        }
    }

    public TynamoDescriptor(Descriptor descriptor) {
        try {
            BeanUtils.copyProperties((Object)this, (Object)descriptor);
            this.copyExtensionsFrom(descriptor);
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage());
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            logger.error(e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            logger.error(e.toString());
            e.printStackTrace();
        }
    }

    public TynamoDescriptor(Class beanType) {
        this.beanType = beanType;
    }

    @Override
    public Object clone() {
        return new TynamoDescriptor(this);
    }

    public void copyFrom(Descriptor descriptor) {
        try {
            BeanUtils.copyProperties((Object)this, (Object)descriptor);
            this.copyExtensionsFrom(descriptor);
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage());
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            logger.error(e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            logger.error(e.toString());
            e.printStackTrace();
        }
    }

    public void copyExtensionsFrom(Descriptor descriptor) {
        Map<String, DescriptorExtension> exts = descriptor.getExtensions();
        for (Map.Entry<String, DescriptorExtension> entry : exts.entrySet()) {
            String key = entry.getKey();
            DescriptorExtension value = entry.getValue();
            try {
                this.addExtension(key, (DescriptorExtension)BeanUtils.cloneBean((Object)value));
            }
            catch (Exception e) {}
        }
    }

    @Override
    public boolean isNonVisual() {
        return this.nonVisual;
    }

    @Override
    public void setNonVisual(boolean nonVisual) {
        this.nonVisual = nonVisual;
    }

    @Deprecated
    public Class getType() {
        return this.getBeanType();
    }

    public Class getBeanType() {
        return this.beanType;
    }

    public void setBeanType(Class beanType) {
        this.beanType = beanType;
    }

    @Override
    public boolean supportsExtension(String keye) {
        return this.getExtension(keye) != null;
    }

    @Override
    public boolean supportsExtension(Class extensionType) {
        return this.supportsExtension(extensionType.getName());
    }

    @Override
    public DescriptorExtension getExtension(String key) {
        return this.extensions.get(key);
    }

    @Override
    public void addExtension(String key, DescriptorExtension extension) {
        this.extensions.put(key, extension);
    }

    @Override
    public void addExtension(Class extensionType, DescriptorExtension extension) {
        this.addExtension(extensionType.getName(), extension);
    }

    @Override
    public void removeExtension(String key) {
        this.extensions.remove(key);
    }

    @Override
    public void removeExtension(Class extensionType) {
        this.removeExtension(extensionType.getName());
    }

    @Override
    public <E extends DescriptorExtension> E getExtension(Class<E> extensionType) {
        return (E)this.extensions.get(extensionType.getName());
    }

    @Override
    public Map<String, DescriptorExtension> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(Map<String, DescriptorExtension> extensions) {
        this.extensions = extensions;
    }
}

