/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.descriptor;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.tynamo.descriptor.Descriptor;
import org.tynamo.descriptor.TynamoDescriptor;
import org.tynamo.descriptor.TynamoPropertyDescriptor;

public class TynamoPropertyDescriptorImpl
extends TynamoDescriptor
implements TynamoPropertyDescriptor {
    private Class propertyType;
    private String name;
    private boolean searchable = true;
    private boolean required;
    private boolean readOnly;
    private int length = 255;
    private boolean large;
    private String format;
    private boolean richText;

    public TynamoPropertyDescriptorImpl(Class beanType, TynamoPropertyDescriptor descriptor) {
        this(beanType, descriptor.getPropertyType());
        try {
            BeanUtils.copyProperties((Object)this, (Object)((TynamoPropertyDescriptorImpl)descriptor));
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage());
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            logger.error(e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            logger.error(e.toString());
            e.printStackTrace();
        }
    }

    public TynamoPropertyDescriptorImpl(Class beanType, Class propertyType) {
        super(beanType);
        this.propertyType = propertyType;
    }

    public TynamoPropertyDescriptorImpl(Class beanType, String name, Class propertyType) {
        this(beanType, propertyType);
        this.setName(name);
    }

    public TynamoPropertyDescriptorImpl(TynamoPropertyDescriptorImpl dto) {
        super(dto);
        try {
            BeanUtils.copyProperties((Object)this, (Object)dto);
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage());
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            logger.error(e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            logger.error(e.toString());
            e.printStackTrace();
        }
    }

    public Class getPropertyType() {
        return this.propertyType;
    }

    public void setPropertyType(Class propertyType) {
        this.propertyType = propertyType;
    }

    public boolean isNumeric() {
        return this.getPropertyType().getName().endsWith("Double") || this.getPropertyType().getName().endsWith("Integer") || this.getPropertyType().getName().endsWith("Float") || this.getPropertyType().getName().endsWith("double") || this.getPropertyType().getName().endsWith("int") || this.getPropertyType().getName().endsWith("float") || this.getPropertyType().getName().endsWith("BigDecimal");
    }

    public boolean isBoolean() {
        return this.getPropertyType().getName().endsWith("boolean") || this.getPropertyType().getName().endsWith("Boolean");
    }

    public boolean isDate() {
        return this.getPropertyType().getName().endsWith("Date");
    }

    public boolean isString() {
        return this.getPropertyType().getName().endsWith("String");
    }

    public boolean isObjectReference() {
        return false;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isIdentifier() {
        return false;
    }

    public boolean isCollection() {
        return false;
    }

    public Object clone() {
        return new TynamoPropertyDescriptorImpl(this);
    }

    public void copyFrom(Descriptor descriptor) {
        super.copyFrom(descriptor);
        if (descriptor instanceof TynamoPropertyDescriptorImpl) {
            try {
                BeanUtils.copyProperties((Object)this, (Object)((TynamoPropertyDescriptorImpl)descriptor));
            }
            catch (IllegalAccessException e) {
                logger.error(e.getMessage());
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                logger.error(e.getMessage());
                e.printStackTrace();
            }
            catch (Exception e) {
                logger.error(e.toString());
                e.printStackTrace();
            }
        }
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public boolean isLarge() {
        return this.large;
    }

    public void setLarge(boolean large) {
        this.large = large;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public boolean isSearchable() {
        return this.searchable;
    }

    public void setSearchable(boolean searchable) {
        this.searchable = searchable;
    }

    public boolean isRichText() {
        return this.richText;
    }

    public void setRichText(boolean richText) {
        this.richText = richText;
    }

    public boolean isEmbedded() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

