/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.descriptor.decorators;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Flow;
import org.apache.tapestry5.func.Predicate;
import org.apache.tapestry5.ioc.ObjectLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tynamo.descriptor.Descriptor;
import org.tynamo.descriptor.EmbeddedDescriptor;
import org.tynamo.descriptor.IMethodDescriptor;
import org.tynamo.descriptor.TynamoClassDescriptor;
import org.tynamo.descriptor.TynamoPropertyDescriptor;
import org.tynamo.descriptor.annotation.handlers.DescriptorAnnotationHandler;
import org.tynamo.descriptor.annotation.handlers.HandledBy;
import org.tynamo.descriptor.decorators.DescriptorDecorator;

public class TynamoDecorator
implements DescriptorDecorator {
    private static final Logger LOGGER = LoggerFactory.getLogger(TynamoDecorator.class);
    private ObjectLocator locator;

    public TynamoDecorator(ObjectLocator locator) {
        this.locator = locator;
    }

    @Override
    public TynamoClassDescriptor decorate(TynamoClassDescriptor descriptor) {
        Annotation[] classAnnotations = descriptor.getBeanType().getAnnotations();
        TynamoClassDescriptor decoratedDescriptor = (TynamoClassDescriptor)descriptor.clone();
        this.decorateFromAnnotations(decoratedDescriptor, classAnnotations);
        decoratedDescriptor.setPropertyDescriptors(this.decoratePropertyDescriptors(descriptor));
        decoratedDescriptor.setMethodDescriptors(this.decorateMethodDescriptors(descriptor));
        return decoratedDescriptor;
    }

    List<TynamoPropertyDescriptor> decoratePropertyDescriptors(TynamoClassDescriptor descriptor) {
        ArrayList<TynamoPropertyDescriptor> decoratedPropertyDescriptors = new ArrayList<TynamoPropertyDescriptor>();
        for (TynamoPropertyDescriptor propertyDescriptor : descriptor.getPropertyDescriptors()) {
            TynamoPropertyDescriptor clonedDescriptor = (TynamoPropertyDescriptor)propertyDescriptor.clone();
            this.decoratePropertyDescriptor(clonedDescriptor);
            if (clonedDescriptor.isEmbedded()) {
                EmbeddedDescriptor embeddedDescriptor = (EmbeddedDescriptor)clonedDescriptor;
                embeddedDescriptor.setEmbeddedClassDescriptor(this.decorate(embeddedDescriptor.getEmbeddedClassDescriptor()));
            }
            decoratedPropertyDescriptors.add(clonedDescriptor);
        }
        return decoratedPropertyDescriptors;
    }

    List<IMethodDescriptor> decorateMethodDescriptors(TynamoClassDescriptor descriptor) {
        ArrayList<IMethodDescriptor> decoratedMethodDescriptors = new ArrayList<IMethodDescriptor>();
        for (IMethodDescriptor methodDescriptor : descriptor.getMethodDescriptors()) {
            IMethodDescriptor clonedDescriptor = (IMethodDescriptor)methodDescriptor.clone();
            this.decorateMethodDescriptor(clonedDescriptor);
            decoratedMethodDescriptors.add(clonedDescriptor);
        }
        return decoratedMethodDescriptors;
    }

    void decoratePropertyDescriptor(TynamoPropertyDescriptor descriptor) {
        this.decorateFromDeclaredField(descriptor);
        this.decorateFromReadMethod(descriptor);
    }

    void decorateFromReadMethod(final TynamoPropertyDescriptor tynamoPropertyDescriptor) {
        try {
            Object[] descriptors = Introspector.getBeanInfo(tynamoPropertyDescriptor.getBeanType()).getPropertyDescriptors();
            PropertyDescriptor beanPropDescriptor = (PropertyDescriptor)((Flow)F.flow((Object[])descriptors).filter((Predicate)new Predicate<PropertyDescriptor>(){

                public boolean accept(PropertyDescriptor descriptor) {
                    return descriptor.getName().equals(tynamoPropertyDescriptor.getName());
                }
            })).first();
            Method readMethod = beanPropDescriptor.getReadMethod();
            if (readMethod != null) {
                this.decorateFromAnnotations(tynamoPropertyDescriptor, readMethod.getAnnotations());
            } else {
                LOGGER.error("There is no readMethod for: " + tynamoPropertyDescriptor.getBeanType().getSimpleName() + "." + tynamoPropertyDescriptor.getName());
            }
        }
        catch (IntrospectionException ex) {
            LOGGER.error("Could not decorate from readMethod: " + tynamoPropertyDescriptor.getBeanType().getSimpleName() + "." + tynamoPropertyDescriptor.getName());
        }
    }

    void decorateFromDeclaredField(TynamoPropertyDescriptor tynamoPropertyDescriptor) {
        block2: {
            try {
                Field propertyField = tynamoPropertyDescriptor.getBeanType().getDeclaredField(tynamoPropertyDescriptor.getName());
                this.decorateFromAnnotations(tynamoPropertyDescriptor, propertyField.getAnnotations());
            }
            catch (NoSuchFieldException ex) {
                if (!LOGGER.isDebugEnabled()) break block2;
                LOGGER.debug("NoSuchFieldException: " + tynamoPropertyDescriptor.getBeanType().getSimpleName() + "." + tynamoPropertyDescriptor.getName());
            }
        }
    }

    void decorateMethodDescriptor(IMethodDescriptor methodDescriptor) {
        try {
            this.decorateFromAnnotations(methodDescriptor, methodDescriptor.getMethod().getAnnotations());
        }
        catch (NoSuchMethodException nsme) {
            LOGGER.warn(ExceptionUtils.getRootCauseMessage((Throwable)nsme));
        }
    }

    void decorateFromAnnotations(Descriptor descriptor, Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            HandledBy handledBy = annotation.annotationType().getAnnotation(HandledBy.class);
            if (handledBy == null) continue;
            try {
                String serviceId = handledBy.value();
                DescriptorAnnotationHandler handler = (DescriptorAnnotationHandler)this.locator.getService(serviceId, DescriptorAnnotationHandler.class);
                handler.decorateFromAnnotation(annotation, descriptor);
            }
            catch (Exception ex) {
                LOGGER.error("error decorating: " + descriptor.toString() + " with " + annotation.toString(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)ex));
            }
        }
    }
}

