/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.descriptor.factories;

import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.beanutils.BeanUtils;
import org.tynamo.descriptor.TynamoPropertyDescriptor;
import org.tynamo.descriptor.TynamoPropertyDescriptorImpl;
import org.tynamo.descriptor.factories.PropertyDescriptorFactory;
import org.tynamo.util.Utils;

public class PropertyDescriptorFactoryImpl
implements PropertyDescriptorFactory {
    private final Collection<String> propertyExcludes;

    public PropertyDescriptorFactoryImpl(Collection<String> propertyExcludes) {
        this.propertyExcludes = propertyExcludes;
    }

    @Override
    public ArrayList<TynamoPropertyDescriptor> buildPropertyDescriptors(Class beanType, BeanInfo beanInfo) throws InvocationTargetException, IllegalAccessException {
        ArrayList<TynamoPropertyDescriptor> result = new ArrayList<TynamoPropertyDescriptor>();
        for (PropertyDescriptor beanPropDescriptor : beanInfo.getPropertyDescriptors()) {
            if (Utils.isExcluded(beanPropDescriptor.getName(), this.propertyExcludes)) continue;
            Class<?> propertyType = beanPropDescriptor.getPropertyType();
            TynamoPropertyDescriptorImpl propDescriptor = new TynamoPropertyDescriptorImpl(beanType, propertyType);
            BeanUtils.copyProperties((Object)propDescriptor, (Object)beanPropDescriptor);
            result.add(propDescriptor);
        }
        return result;
    }
}

