/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.components;

import java.lang.annotation.Annotation;
import java.util.Locale;
import java.util.Map;
import org.apache.tapestry5.Block;
import org.apache.tapestry5.ComponentAction;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Field;
import org.apache.tapestry5.FieldTranslator;
import org.apache.tapestry5.FieldValidator;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.beaneditor.BeanModel;
import org.apache.tapestry5.beaneditor.PropertyModel;
import org.apache.tapestry5.internal.BeanValidationContext;
import org.apache.tapestry5.ioc.AnnotationProvider;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Primary;
import org.apache.tapestry5.ioc.internal.util.TapestryException;
import org.apache.tapestry5.ioc.services.ClassPropertyAdapter;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.ioc.services.PropertyAdapter;
import org.apache.tapestry5.services.BeanModelSource;
import org.apache.tapestry5.services.DataTypeAnalyzer;
import org.apache.tapestry5.services.Environment;
import org.apache.tapestry5.services.FieldTranslatorSource;
import org.apache.tapestry5.services.FieldValidatorDefaultSource;
import org.apache.tapestry5.services.FormSupport;
import org.tynamo.descriptor.TynamoPropertyDescriptor;
import org.tynamo.search.SearchFilterOperator;
import org.tynamo.search.SearchFilterPredicate;
import org.tynamo.services.PropertySearchFilterContext;
import org.tynamo.services.SearchFilterBlockSource;

public class PropertySearchFilter {
    @Parameter(required=true, allowNull=false)
    private Map.Entry<TynamoPropertyDescriptor, SearchFilterPredicate> entry;
    @Inject
    private SearchFilterBlockSource searchFilterBlockSource;
    @Inject
    private Messages messages;
    @Inject
    private Locale locale;
    @Inject
    private ComponentResources resources;
    @Inject
    private FieldTranslatorSource fieldTranslatorSource;
    @Inject
    private FieldValidatorDefaultSource fieldValidatorDefaultSource;
    @Inject
    private Environment environment;
    @Inject
    private PropertyAccess propertyAccess;
    @Inject
    @Primary
    DataTypeAnalyzer dataTypeAnalyzer;
    @Inject
    private BeanModelSource beanModelSource;
    @Environmental
    private FormSupport formSupport;
    private static final ComponentAction CLEANUP_ENVIRONMENT = new CleanupEnvironment();
    private BeanModel model;
    private PropertyModel propertyModel;

    private String resolveDataType(TynamoPropertyDescriptor descriptor) {
        ClassPropertyAdapter classAdapter = this.propertyAccess.getAdapter(descriptor.getBeanType());
        PropertyAdapter adapter = classAdapter.getPropertyAdapter(descriptor.getName());
        return this.dataTypeAnalyzer.identifyDataType(adapter);
    }

    Block beginRender() {
        String dataType = this.resolveDataType(this.entry.getKey());
        if (dataType == null) {
            throw new RuntimeException(String.format("The data type for property '%s' of type %s is null.", this.entry.getKey().getName(), this.entry.getKey().getBeanType()));
        }
        try {
            return this.searchFilterBlockSource.toBlock(dataType);
        }
        catch (RuntimeException ex) {
            String message = this.messages.format("core-block-error", new Object[]{this.entry.getKey().getName(), dataType, null, ex});
            throw new TapestryException(message, this.resources.getLocation(), (Throwable)ex);
        }
    }

    boolean beforeRenderBody() {
        return false;
    }

    void setupRender() {
        this.formSupport.storeAndExecute((Object)this, (ComponentAction)new SetupEnvironment(this.entry.getKey().getName()));
    }

    void cleanupRender() {
        this.formSupport.storeAndExecute((Object)this, CLEANUP_ENVIRONMENT);
    }

    void setupEnvironment(final String propertyName) {
        this.model = this.beanModelSource.createEditModel(this.entry.getKey().getBeanType(), this.resources.getContainerMessages());
        this.propertyModel = this.model.get(propertyName);
        PropertySearchFilterContext context = new PropertySearchFilterContext(){

            @Override
            public Messages getContainerMessages() {
                return PropertySearchFilter.this.messages;
            }

            @Override
            public String getLabel() {
                return PropertySearchFilter.this.propertyModel.getLabel();
            }

            @Override
            public boolean isEnabled() {
                return ((SearchFilterPredicate)PropertySearchFilter.this.entry.getValue()).isEnabled();
            }

            @Override
            public void setEnabled(boolean value) {
                ((SearchFilterPredicate)PropertySearchFilter.this.entry.getValue()).setEnabled(value);
            }

            @Override
            public String getPropertyId() {
                return PropertySearchFilter.this.propertyModel.getId();
            }

            @Override
            public Class getPropertyType() {
                return PropertySearchFilter.this.propertyModel.getPropertyType();
            }

            @Override
            public Object getLowValue() {
                return ((SearchFilterPredicate)PropertySearchFilter.this.entry.getValue()).getLowValue();
            }

            @Override
            public Object getHighValue() {
                return ((SearchFilterPredicate)PropertySearchFilter.this.entry.getValue()).getHighValue();
            }

            @Override
            public FieldTranslator getTranslator(Field field) {
                return PropertySearchFilter.this.fieldTranslatorSource.createDefaultTranslator(field, propertyName, PropertySearchFilter.this.messages, PropertySearchFilter.this.locale, PropertySearchFilter.this.propertyModel.getPropertyType(), (AnnotationProvider)PropertySearchFilter.this.propertyModel.getConduit());
            }

            @Override
            public FieldValidator getValidator(Field field) {
                return PropertySearchFilter.this.fieldValidatorDefaultSource.createDefaultValidator(field, propertyName, PropertySearchFilter.this.messages, PropertySearchFilter.this.locale, PropertySearchFilter.this.propertyModel.getPropertyType(), (AnnotationProvider)PropertySearchFilter.this.propertyModel.getConduit());
            }

            @Override
            public void setLowValue(Object value) {
                ((SearchFilterPredicate)PropertySearchFilter.this.entry.getValue()).setLowValue(value);
            }

            @Override
            public void setHighValue(Object value) {
                ((SearchFilterPredicate)PropertySearchFilter.this.entry.getValue()).setHighValue(value);
            }

            @Override
            public String getOperatorId() {
                return PropertySearchFilter.this.propertyModel.getId() + "_searchoperator";
            }

            @Override
            public SearchFilterOperator getOperatorValue() {
                return ((SearchFilterPredicate)PropertySearchFilter.this.entry.getValue()).getOperator();
            }

            @Override
            public void setOperatorValue(SearchFilterOperator value) {
                ((SearchFilterPredicate)PropertySearchFilter.this.entry.getValue()).setOperator(value);
            }

            public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                return (T)PropertySearchFilter.this.propertyModel.getAnnotation(annotationClass);
            }
        };
        this.environment.push(PropertySearchFilterContext.class, (Object)context);
        BeanValidationContext beanValidationContext = (BeanValidationContext)this.environment.peek(BeanValidationContext.class);
        if (beanValidationContext != null) {
            beanValidationContext.setCurrentProperty(propertyName);
        }
    }

    void cleanupEnvironment() {
        this.environment.pop(PropertySearchFilterContext.class);
    }

    static class CleanupEnvironment
    implements ComponentAction<PropertySearchFilter> {
        private static final long serialVersionUID = 1L;

        CleanupEnvironment() {
        }

        public void execute(PropertySearchFilter component) {
            component.cleanupEnvironment();
        }

        public String toString() {
            return "PropertySearchFilter.CleanupEnvironment";
        }
    }

    static class SetupEnvironment
    implements ComponentAction<PropertySearchFilter> {
        private static final long serialVersionUID = 1L;
        private final String property;

        public SetupEnvironment(String property) {
            this.property = property;
        }

        public void execute(PropertySearchFilter component) {
            component.setupEnvironment(this.property);
        }

        public String toString() {
            return String.format("PropertySearchFilter.SetupEnvironment[%s]", this.property);
        }
    }
}

