/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.descriptor;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.tynamo.descriptor.Descriptor;
import org.tynamo.descriptor.TynamoDescriptor;
import org.tynamo.descriptor.TynamoPropertyDescriptor;

public class TynamoPropertyDescriptorImpl
extends TynamoDescriptor
implements TynamoPropertyDescriptor {
    private Class propertyType;
    private String name;
    private boolean searchable = true;
    private boolean required;
    private boolean readOnly;
    private int length = 255;
    private boolean large;
    private String format;
    private boolean richText;

    public TynamoPropertyDescriptorImpl(Class beanType, TynamoPropertyDescriptor descriptor) {
        this(beanType, descriptor.getPropertyType());
        try {
            BeanUtils.copyProperties((Object)this, (Object)((TynamoPropertyDescriptorImpl)descriptor));
        }
        catch (IllegalAccessException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public TynamoPropertyDescriptorImpl(Class beanType, Class propertyType) {
        super(beanType);
        this.propertyType = propertyType;
    }

    public TynamoPropertyDescriptorImpl(Class beanType, String name, Class propertyType) {
        this(beanType, propertyType);
        this.setName(name);
    }

    public TynamoPropertyDescriptorImpl(TynamoPropertyDescriptorImpl dto) {
        super(dto);
        try {
            BeanUtils.copyProperties((Object)this, (Object)dto);
        }
        catch (IllegalAccessException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Class getPropertyType() {
        return this.propertyType;
    }

    public void setPropertyType(Class propertyType) {
        this.propertyType = propertyType;
    }

    @Override
    public boolean isNumeric() {
        return this.getPropertyType().getName().endsWith("Double") || this.getPropertyType().getName().endsWith("Integer") || this.getPropertyType().getName().endsWith("Float") || this.getPropertyType().getName().endsWith("double") || this.getPropertyType().getName().endsWith("int") || this.getPropertyType().getName().endsWith("float") || this.getPropertyType().getName().endsWith("BigDecimal");
    }

    @Override
    public boolean isBoolean() {
        return this.getPropertyType().getName().endsWith("boolean") || this.getPropertyType().getName().endsWith("Boolean");
    }

    @Override
    public boolean isDate() {
        return this.getPropertyType().getName().endsWith("Date");
    }

    @Override
    public boolean isString() {
        return this.getPropertyType().getName().endsWith("String");
    }

    @Override
    public boolean isObjectReference() {
        return false;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public void setRequired(boolean required) {
        this.required = required;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public boolean isIdentifier() {
        return false;
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    @Override
    public Object clone() {
        return new TynamoPropertyDescriptorImpl(this);
    }

    @Override
    public void copyFrom(Descriptor descriptor) {
        super.copyFrom(descriptor);
        if (descriptor instanceof TynamoPropertyDescriptorImpl) {
            try {
                BeanUtils.copyProperties((Object)this, (Object)((TynamoPropertyDescriptorImpl)descriptor));
            }
            catch (IllegalAccessException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public void setLength(int length) {
        this.length = length;
    }

    @Override
    public boolean isLarge() {
        return this.large;
    }

    @Override
    public void setLarge(boolean large) {
        this.large = large;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    public boolean isSearchable() {
        return this.searchable;
    }

    @Override
    public void setSearchable(boolean searchable) {
        this.searchable = searchable;
    }

    @Override
    public boolean isRichText() {
        return this.richText;
    }

    @Override
    public void setRichText(boolean richText) {
        this.richText = richText;
    }

    @Override
    public boolean isEmbedded() {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }
}

