/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.hibernate.pages;

import java.lang.annotation.Annotation;
import org.apache.tapestry5.beaneditor.BeanModel;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.Environment;
import org.tynamo.descriptor.TynamoClassDescriptor;
import org.tynamo.pages.ModelPage;
import org.tynamo.services.TynamoBeanContext;

public abstract class HibernateModelPage
extends ModelPage {
    @Inject
    private Environment environment;
    private TynamoClassDescriptor classDescriptor;
    private BeanModel beanModel;
    private Object bean;

    protected void onPrepare() {
        this.pushTynamoBeanContext();
    }

    protected void pushTynamoBeanContext() {
        TynamoBeanContext context = new TynamoBeanContext(){

            public Class<?> getBeanClass() {
                return HibernateModelPage.this.classDescriptor.getType();
            }

            public <T extends Annotation> T getAnnotation(Class<T> type) {
                return this.getBeanClass().getAnnotation(type);
            }

            public Object getBean() {
                return HibernateModelPage.this.bean;
            }
        };
        this.environment.push(TynamoBeanContext.class, (Object)context);
    }

    protected void activate(Object bean, TynamoClassDescriptor classDescriptor, BeanModel beanModel) {
        this.bean = bean;
        this.classDescriptor = classDescriptor;
        this.beanModel = beanModel;
    }

    protected void cleanupRender() {
        this.bean = null;
        this.classDescriptor = null;
        this.beanModel = null;
    }

    final void onActivate(Class clazz, String id) throws Exception {
        this.activate(this.getContextValueEncoder().toValue(clazz, id), this.getDescriptorService().getClassDescriptor(clazz), this.createBeanModel(clazz));
    }

    protected Object[] onPassivate() {
        return new Object[]{this.getClassDescriptor().getType(), this.getBean()};
    }

    public final TynamoClassDescriptor getClassDescriptor() {
        return this.classDescriptor;
    }

    public final BeanModel getBeanModel() {
        return this.beanModel;
    }

    public final Object getBean() {
        return this.bean;
    }

    public final void setBean(Object bean) {
        this.bean = bean;
    }

    public boolean isAllowRemove() {
        return this.getClassDescriptor().isAllowRemove() && !this.getClassDescriptor().isChild();
    }
}

