/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.hibernate.services;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import ognl.Ognl;
import ognl.OgnlException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry5.hibernate.HibernateSessionSource;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.metadata.CollectionMetadata;
import org.hibernate.type.ComponentType;
import org.hibernate.type.Type;
import org.tynamo.descriptor.CollectionDescriptor;
import org.tynamo.descriptor.Descriptor;
import org.tynamo.descriptor.DescriptorDecorator;
import org.tynamo.descriptor.DescriptorExtension;
import org.tynamo.descriptor.DescriptorFactory;
import org.tynamo.descriptor.EmbeddedDescriptor;
import org.tynamo.descriptor.IdentifierDescriptor;
import org.tynamo.descriptor.IdentifierDescriptorImpl;
import org.tynamo.descriptor.ObjectReferenceDescriptor;
import org.tynamo.descriptor.TynamoClassDescriptor;
import org.tynamo.descriptor.TynamoPropertyDescriptor;
import org.tynamo.descriptor.extension.EnumReferenceDescriptor;
import org.tynamo.exception.MetadataNotFoundException;
import org.tynamo.exception.TynamoRuntimeException;

public class HibernateDescriptorDecorator
implements DescriptorDecorator {
    protected static final Log LOG = LogFactory.getLog(HibernateDescriptorDecorator.class);
    private HibernateSessionSource hibernateSessionSource;
    private DescriptorFactory descriptorFactory;
    private final int largeColumnLength;
    private final boolean ignoreNonHibernateTypes;

    public HibernateDescriptorDecorator(HibernateSessionSource hibernateSessionSource, DescriptorFactory descriptorFactory, int largeColumnLength, boolean ignoreNonHibernateTypes) {
        this.hibernateSessionSource = hibernateSessionSource;
        this.descriptorFactory = descriptorFactory;
        this.largeColumnLength = largeColumnLength;
        this.ignoreNonHibernateTypes = ignoreNonHibernateTypes;
    }

    public TynamoClassDescriptor decorate(TynamoClassDescriptor descriptor) {
        ArrayList<IdentifierDescriptor> decoratedPropertyDescriptors = new ArrayList<IdentifierDescriptor>();
        Class type = descriptor.getType();
        ClassMetadata classMetaData = null;
        try {
            classMetaData = this.findMetadata(type);
        }
        catch (MetadataNotFoundException e) {
            if (this.ignoreNonHibernateTypes) {
                LOG.warn((Object)("MetadataNotFound! Ignoring:" + descriptor.getType().toString()));
                return descriptor;
            }
            throw new TynamoRuntimeException((Throwable)((Object)e));
        }
        for (TynamoPropertyDescriptor propertyDescriptor : descriptor.getPropertyDescriptors()) {
            try {
                IdentifierDescriptor descriptorReference;
                if (propertyDescriptor.getName().equals(this.getIdentifierProperty(type))) {
                    descriptorReference = this.createIdentifierDescriptor(type, propertyDescriptor, descriptor);
                } else if (this.notAHibernateProperty(classMetaData, propertyDescriptor)) {
                    propertyDescriptor.setSearchable(false);
                    descriptorReference = propertyDescriptor;
                } else {
                    Property mappingProperty = this.getMapping(type).getProperty(propertyDescriptor.getName());
                    descriptorReference = this.decoratePropertyDescriptor(type, mappingProperty, propertyDescriptor, descriptor);
                }
                decoratedPropertyDescriptors.add(descriptorReference);
            }
            catch (HibernateException e) {
                throw new TynamoRuntimeException((Throwable)e);
            }
        }
        descriptor.setPropertyDescriptors(decoratedPropertyDescriptors);
        return descriptor;
    }

    protected TynamoPropertyDescriptor decoratePropertyDescriptor(Class type, Property mappingProperty, TynamoPropertyDescriptor descriptor, TynamoClassDescriptor parentClassDescriptor) {
        if (this.isFormula(mappingProperty)) {
            descriptor.setReadOnly(true);
            return descriptor;
        }
        descriptor.setLength(this.findColumnLength(mappingProperty));
        descriptor.setLarge(this.isLarge(mappingProperty));
        if (!mappingProperty.isOptional()) {
            descriptor.setRequired(true);
        }
        if (!mappingProperty.isInsertable() && !mappingProperty.isUpdateable()) {
            descriptor.setReadOnly(true);
        }
        TynamoPropertyDescriptor descriptorReference = descriptor;
        Type hibernateType = mappingProperty.getType();
        if (mappingProperty.getType() instanceof ComponentType) {
            descriptorReference = this.buildEmbeddedDescriptor(type, mappingProperty, descriptor, parentClassDescriptor);
        } else if (Collection.class.isAssignableFrom(descriptor.getPropertyType())) {
            descriptorReference = this.decorateCollectionDescriptor(type, descriptor, parentClassDescriptor);
        } else if (hibernateType.isAssociationType()) {
            descriptorReference = this.decorateAssociationDescriptor(type, mappingProperty, descriptor, parentClassDescriptor);
        } else if (hibernateType.getReturnedClass().isEnum()) {
            descriptor.addExtension(EnumReferenceDescriptor.class.getName(), (DescriptorExtension)new EnumReferenceDescriptor(hibernateType.getReturnedClass()));
        }
        return descriptorReference;
    }

    private EmbeddedDescriptor buildEmbeddedDescriptor(Class type, Property mappingProperty, TynamoPropertyDescriptor descriptor, TynamoClassDescriptor parentClassDescriptor) {
        Component componentMapping = (Component)mappingProperty.getValue();
        TynamoClassDescriptor baseDescriptor = this.descriptorFactory.buildClassDescriptor(descriptor.getPropertyType());
        EmbeddedDescriptor embeddedDescriptor = new EmbeddedDescriptor(type, baseDescriptor);
        embeddedDescriptor.copyFrom((Descriptor)descriptor);
        ArrayList<TynamoPropertyDescriptor> decoratedProperties = new ArrayList<TynamoPropertyDescriptor>();
        for (TynamoPropertyDescriptor propertyDescriptor : embeddedDescriptor.getPropertyDescriptors()) {
            if (this.notAHibernateProperty(componentMapping, propertyDescriptor)) {
                decoratedProperties.add(propertyDescriptor);
                continue;
            }
            Property property = componentMapping.getProperty(propertyDescriptor.getName());
            TynamoPropertyDescriptor TynamoPropertyDescriptor2 = this.decoratePropertyDescriptor(embeddedDescriptor.getBeanType(), property, propertyDescriptor, parentClassDescriptor);
            decoratedProperties.add(TynamoPropertyDescriptor2);
        }
        embeddedDescriptor.setPropertyDescriptors(decoratedProperties);
        return embeddedDescriptor;
    }

    protected List sortPropertyDescriptors(Class type, List propertyDescriptors) {
        ArrayList<Object> sortedPropertyDescriptors = new ArrayList<Object>();
        try {
            sortedPropertyDescriptors.add(Ognl.getValue((String)"#this.{? identifier == true}[0]", (Object)propertyDescriptors));
            Iterator iter = this.getMapping(type).getPropertyIterator();
            while (iter.hasNext()) {
                Property mapping = (Property)iter.next();
                sortedPropertyDescriptors.addAll((List)Ognl.getValue((String)("#this.{ ? name == \"" + mapping.getName() + "\"}"), (Object)propertyDescriptors));
            }
        }
        catch (Exception ex) {
            throw new TynamoRuntimeException((Throwable)ex);
        }
        return sortedPropertyDescriptors;
    }

    protected ClassMetadata findMetadata(Class type) throws MetadataNotFoundException {
        ClassMetadata metaData = this.hibernateSessionSource.getSessionFactory().getClassMetadata(type);
        if (metaData != null) {
            return metaData;
        }
        if (!type.equals(Object.class)) {
            return this.findMetadata(type.getSuperclass());
        }
        throw new MetadataNotFoundException("Failed to find metadata.");
    }

    private boolean isFormula(Property mappingProperty) {
        Iterator iter = mappingProperty.getColumnIterator();
        while (iter.hasNext()) {
            Selectable selectable = (Selectable)iter.next();
            if (!selectable.isFormula()) continue;
            return true;
        }
        return false;
    }

    protected boolean notAHibernateProperty(Component componentMapping, TynamoPropertyDescriptor propertyDescriptor) {
        Iterator iter = componentMapping.getPropertyIterator();
        while (iter.hasNext()) {
            Property property = (Property)iter.next();
            if (!property.getName().equals(propertyDescriptor.getName())) continue;
            return false;
        }
        return true;
    }

    private boolean isLarge(Property mappingProperty) {
        return this.findColumnLength(mappingProperty) != 255 && this.findColumnLength(mappingProperty) > this.largeColumnLength;
    }

    private int findColumnLength(Property mappingProperty) {
        int length = 0;
        Iterator iter = mappingProperty.getColumnIterator();
        while (iter.hasNext()) {
            Column column = (Column)iter.next();
            length += column.getLength();
        }
        return length;
    }

    protected boolean notAHibernateProperty(ClassMetadata classMetaData, TynamoPropertyDescriptor descriptor) {
        try {
            return (Boolean)Ognl.getValue((String)("propertyNames.{ ? #this == \"" + descriptor.getName() + "\"}.size() == 0"), (Object)classMetaData);
        }
        catch (OgnlException oe) {
            throw new TynamoRuntimeException((Throwable)oe);
        }
    }

    private IdentifierDescriptor createIdentifierDescriptor(Class type, TynamoPropertyDescriptor descriptor, TynamoClassDescriptor parentClassDescriptor) {
        IdentifierDescriptorImpl identifierDescriptor;
        PersistentClass mapping = this.getMapping(type);
        if (mapping.getProperty(descriptor.getName()).getType() instanceof ComponentType) {
            EmbeddedDescriptor embeddedDescriptor = this.buildEmbeddedDescriptor(type, mapping.getProperty(descriptor.getName()), descriptor, parentClassDescriptor);
            embeddedDescriptor.setIdentifier(true);
            identifierDescriptor = embeddedDescriptor;
        } else {
            identifierDescriptor = new IdentifierDescriptorImpl(type, descriptor);
        }
        if (((SimpleValue)mapping.getIdentifier()).getIdentifierGeneratorStrategy().equals("assigned")) {
            identifierDescriptor.setGenerated(false);
        }
        return identifierDescriptor;
    }

    protected PersistentClass getMapping(Class type) {
        Configuration cfg = this.hibernateSessionSource.getConfiguration();
        return cfg.getClassMapping(type.getName());
    }

    private CollectionDescriptor decorateCollectionDescriptor(Class type, TynamoPropertyDescriptor descriptor, TynamoClassDescriptor parentClassDescriptor) {
        try {
            CollectionDescriptor collectionDescriptor = new CollectionDescriptor(type, descriptor);
            org.hibernate.mapping.Collection collectionMapping = this.findCollectionMapping(type, descriptor.getName());
            collectionDescriptor.setChildRelationship(collectionMapping.hasOrphanDelete());
            CollectionMetadata collectionMetaData = this.hibernateSessionSource.getSessionFactory().getCollectionMetadata(collectionMapping.getRole());
            collectionDescriptor.setElementType(collectionMetaData.getElementType().getReturnedClass());
            collectionDescriptor.setOneToMany(collectionMapping.isOneToMany());
            this.decorateOneToManyCollection(parentClassDescriptor, collectionDescriptor, collectionMapping);
            return collectionDescriptor;
        }
        catch (HibernateException e) {
            throw new TynamoRuntimeException((Throwable)e);
        }
    }

    public TynamoPropertyDescriptor decorateAssociationDescriptor(Class type, Property mappingProperty, TynamoPropertyDescriptor descriptor, TynamoClassDescriptor parentClassDescriptor) {
        ObjectReferenceDescriptor descriptorReference;
        block10: {
            Type hibernateType = mappingProperty.getType();
            Class parentClassType = parentClassDescriptor.getType();
            descriptorReference = new ObjectReferenceDescriptor(type, descriptor, hibernateType.getReturnedClass());
            try {
                Field propertyField = parentClassType.getDeclaredField(descriptor.getName());
                PropertyDescriptor beanPropDescriptor = (PropertyDescriptor)Ognl.getValue((String)("propertyDescriptors.{? name == '" + descriptor.getName() + "'}[0]"), (Object)Introspector.getBeanInfo(parentClassType));
                Method readMethod = beanPropDescriptor.getReadMethod();
                String inverseProperty = "";
                if (readMethod.isAnnotationPresent(OneToOne.class)) {
                    inverseProperty = readMethod.getAnnotation(OneToOne.class).mappedBy();
                } else if (propertyField.isAnnotationPresent(OneToOne.class)) {
                    inverseProperty = propertyField.getAnnotation(OneToOne.class).mappedBy();
                } else {
                    return descriptorReference;
                }
                if (!"".equals(inverseProperty)) break block10;
                Class<?> returnType = readMethod.getReturnType();
                for (int i = 0; i < returnType.getDeclaredMethods().length; ++i) {
                    if (!returnType.getDeclaredMethods()[i].getReturnType().equals(propertyField.getDeclaringClass())) continue;
                    Method theProperty = returnType.getDeclaredMethods()[i];
                    inverseProperty = theProperty.getName().substring(3).toLowerCase();
                    break;
                }
            }
            catch (SecurityException e) {
                LOG.error((Object)e.getMessage());
            }
            catch (NoSuchFieldException e) {
                LOG.error((Object)e.getMessage());
            }
            catch (OgnlException e) {
                LOG.error((Object)e.getMessage());
            }
            catch (IntrospectionException e) {
                LOG.error((Object)e.getMessage());
            }
        }
        return descriptorReference;
    }

    private void decorateOneToManyCollection(TynamoClassDescriptor parentClassDescriptor, CollectionDescriptor collectionDescriptor, org.hibernate.mapping.Collection collectionMapping) {
        Class type = parentClassDescriptor.getType();
        if (collectionDescriptor.isOneToMany() && collectionMapping.isInverse()) {
            try {
                Field propertyField = type.getDeclaredField(collectionDescriptor.getName());
                PropertyDescriptor beanPropDescriptor = (PropertyDescriptor)Ognl.getValue((String)("propertyDescriptors.{? name == '" + collectionDescriptor.getName() + "'}[0]"), (Object)Introspector.getBeanInfo(type));
                Method readMethod = beanPropDescriptor.getReadMethod();
                String mappedBy = "";
                if (readMethod.isAnnotationPresent(OneToMany.class)) {
                    mappedBy = readMethod.getAnnotation(OneToMany.class).mappedBy();
                } else if (propertyField.isAnnotationPresent(OneToMany.class)) {
                    mappedBy = propertyField.getAnnotation(OneToMany.class).mappedBy();
                }
                if (!"".equals(mappedBy)) {
                    collectionDescriptor.setInverseProperty(mappedBy);
                }
                parentClassDescriptor.setHasCyclicRelationships(true);
            }
            catch (SecurityException e) {
                LOG.error((Object)e.getMessage());
            }
            catch (NoSuchFieldException e) {
                LOG.error((Object)e.getMessage());
            }
            catch (OgnlException e) {
                LOG.error((Object)e.getMessage());
            }
            catch (IntrospectionException e) {
                LOG.error((Object)e.getMessage());
            }
        }
    }

    protected org.hibernate.mapping.Collection findCollectionMapping(Class type, String name) {
        String roleName = type.getName() + "." + name;
        org.hibernate.mapping.Collection collectionMapping = this.hibernateSessionSource.getConfiguration().getCollectionMapping(roleName);
        if (collectionMapping != null) {
            return collectionMapping;
        }
        if (!type.equals(Object.class)) {
            return this.findCollectionMapping(type.getSuperclass(), name);
        }
        throw new MetadataNotFoundException("Metadata not found.");
    }

    public String getIdentifierProperty(Class type) {
        try {
            return this.hibernateSessionSource.getSessionFactory().getClassMetadata(type).getIdentifierPropertyName();
        }
        catch (HibernateException e) {
            throw new TynamoRuntimeException((Throwable)e);
        }
    }
}

