/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.hibernate.services;

import java.util.Iterator;
import org.apache.tapestry5.hibernate.HibernateConfigurer;
import org.apache.tapestry5.hibernate.HibernateSessionSource;
import org.apache.tapestry5.hibernate.HibernateTransactionDecorator;
import org.apache.tapestry5.ioc.Configuration;
import org.apache.tapestry5.ioc.MappedConfiguration;
import org.apache.tapestry5.ioc.OrderedConfiguration;
import org.apache.tapestry5.ioc.ServiceBinder;
import org.apache.tapestry5.ioc.annotations.InjectService;
import org.apache.tapestry5.ioc.annotations.Match;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.services.BeanBlockContribution;
import org.apache.tapestry5.services.LibraryMapping;
import org.hibernate.mapping.PersistentClass;
import org.tynamo.VersionedModule;
import org.tynamo.descriptor.DescriptorDecorator;
import org.tynamo.descriptor.DescriptorFactory;
import org.tynamo.descriptor.annotation.AnnotationDecorator;
import org.tynamo.hibernate.TynamoInterceptor;
import org.tynamo.hibernate.TynamoInterceptorConfigurer;
import org.tynamo.hibernate.services.HibernateDescriptorDecorator;
import org.tynamo.hibernate.services.HibernatePersistenceService;
import org.tynamo.hibernate.services.HibernatePersistenceServiceImpl;
import org.tynamo.hibernate.validation.HibernateClassValidatorFactory;
import org.tynamo.hibernate.validation.HibernateValidationDelegate;
import org.tynamo.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TynamoHibernateModule
extends VersionedModule {
    public static void bind(ServiceBinder binder) {
        binder.bind(HibernatePersistenceService.class, HibernatePersistenceServiceImpl.class);
        binder.bind(HibernateClassValidatorFactory.class, HibernateClassValidatorFactory.class);
        binder.bind(HibernateValidationDelegate.class, HibernateValidationDelegate.class);
        binder.bind(TynamoInterceptor.class);
        binder.bind(HibernateConfigurer.class, TynamoInterceptorConfigurer.class).withId("TynamoInterceptorConfigurer");
    }

    public static void contributeComponentClassResolver(Configuration<LibraryMapping> configuration) {
        configuration.add((Object)new LibraryMapping("tynamo-hibernate", "org.tynamo.hibernate"));
    }

    public static void contributeClasspathAssetAliasManager(MappedConfiguration<String, String> configuration) {
        configuration.add((Object)("tynamo-hibernate/" + version), (Object)"org/tynamo/hibernate");
    }

    public static void contributeValidationMessagesSource(OrderedConfiguration<String> configuration) {
        configuration.add("Tynamo", (Object)"ValidationMessages", new String[0]);
    }

    @Match(value={"HibernatePersistenceService"})
    public static <T> T decorateTransactionally(HibernateTransactionDecorator decorator, Class<T> serviceInterface, T delegate, String serviceId) {
        return (T)decorator.build(serviceInterface, delegate, serviceId);
    }

    public static void contributeDefaultDataTypeAnalyzer(MappedConfiguration<Class, String> configuration) {
    }

    public static void contributeBeanBlockSource(Configuration<BeanBlockContribution> configuration) {
    }

    public static void contributeDescriptorFactory(OrderedConfiguration<DescriptorDecorator> configuration, HibernateDescriptorDecorator hibernateDescriptorDecorator) {
        configuration.add("Hibernate", (Object)hibernateDescriptorDecorator, new String[0]);
        configuration.add("Annotation", (Object)new AnnotationDecorator(), new String[0]);
    }

    public static void contributeDescriptorService(Configuration<Class> configuration, HibernateSessionSource hibernateSessionSource) {
        org.hibernate.cfg.Configuration config = hibernateSessionSource.getConfiguration();
        Iterator mappings = config.getClassMappings();
        while (mappings.hasNext()) {
            PersistentClass persistentClass = (PersistentClass)mappings.next();
            Class entityClass = persistentClass.getMappedClass();
            if (entityClass == null) continue;
            configuration.add((Object)entityClass);
        }
    }

    public static void contributeTynamoDataTypeAnalyzer(OrderedConfiguration<Pair> configuration) {
        TynamoHibernateModule.addPairToOrderedConfiguration(configuration, "hidden", "hidden");
        TynamoHibernateModule.addPairToOrderedConfiguration(configuration, "readOnly", "readOnly");
        TynamoHibernateModule.addPairToOrderedConfiguration(configuration, "richText", "fckEditor");
        TynamoHibernateModule.addPairToOrderedConfiguration(configuration, "string and large and !identifier", "longtext");
        TynamoHibernateModule.addPairToOrderedConfiguration(configuration, "date", "dateEditor");
        TynamoHibernateModule.addPairToOrderedConfiguration(configuration, "identifier && generated", "readOnly");
        TynamoHibernateModule.addPairToOrderedConfiguration(configuration, "identifier && not(generated) && string", "identifierEditor");
        TynamoHibernateModule.addPairToOrderedConfiguration(configuration, "supportsExtension('org.tynamo.descriptor.extension.BlobDescriptorExtension')", "blob");
        TynamoHibernateModule.addPairToOrderedConfiguration(configuration, "objectReference", "single-valued-association");
        TynamoHibernateModule.addPairToOrderedConfiguration(configuration, "collection && not(childRelationship)", "many-valued-association");
        TynamoHibernateModule.addPairToOrderedConfiguration(configuration, "collection && childRelationship", "composition");
        TynamoHibernateModule.addPairToOrderedConfiguration(configuration, "name == 'id'", "readOnly");
        TynamoHibernateModule.addPairToOrderedConfiguration(configuration, "embedded", "embedded");
    }

    private static void addPairToOrderedConfiguration(OrderedConfiguration<Pair> configuration, String key, String value) {
        configuration.add(key, (Object)new Pair((Object)key, (Object)value), new String[0]);
    }

    public static void contributePropertyDescriptorFactory(Configuration<String> configuration) {
        configuration.add((Object)"exclude.*");
        configuration.add((Object)"class");
    }

    public static void contributeMethodDescriptorFactory(Configuration<String> configuration) {
        configuration.add((Object)"shouldExclude");
        configuration.add((Object)"set.*");
        configuration.add((Object)"get.*");
        configuration.add((Object)"is.*");
        configuration.add((Object)"equals");
        configuration.add((Object)"wait");
        configuration.add((Object)"toString");
        configuration.add((Object)"notify.*");
        configuration.add((Object)"hashCode");
    }

    public static HibernateDescriptorDecorator buildHibernateDescriptorDecorator(HibernateSessionSource hibernateSessionSource, DescriptorFactory descriptorFactory, @Symbol(value="trails.hibernate.large-column-length") int largeColumnLength, @Symbol(value="trails.hibernate.ignore-non-hibernate-types") boolean ignoreNonHibernateTypes) {
        return new HibernateDescriptorDecorator(hibernateSessionSource, descriptorFactory, largeColumnLength, ignoreNonHibernateTypes);
    }

    public static void contributeFactoryDefaults(MappedConfiguration<String, String> configuration) {
        configuration.add((Object)"trails.hibernate.large-column-length", (Object)"100");
        configuration.add((Object)"trails.hibernate.ignore-non-hibernate-types", (Object)"false");
    }

    public static void contributeHibernateSessionSource(OrderedConfiguration<HibernateConfigurer> config, @InjectService(value="TynamoInterceptorConfigurer") HibernateConfigurer trailsInterceptorConfigurer) {
        config.add("TynamoInterceptorConfigurer", (Object)trailsInterceptorConfigurer, new String[0]);
    }
}

