/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.hibernate.validation;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.tapestry5.ioc.services.ThreadLocale;
import org.hibernate.validator.ClassValidator;
import org.hibernate.validator.InvalidStateException;
import org.hibernate.validator.InvalidValue;
import org.hibernate.validator.MessageInterpolator;
import org.hibernate.validator.Validator;
import org.tynamo.util.Utils;

public class HibernateClassValidatorFactory {
    private static Map classValidator = new HashMap();
    private TynamoMessageInterpolator messageInterpolator = new TynamoMessageInterpolator();
    ThreadLocale threadLocale;

    public HibernateClassValidatorFactory(ThreadLocale threadLocale) {
        this.threadLocale = threadLocale;
    }

    public void validateEntity(Object entity) {
        InvalidValue[] invalidValues;
        Locale locale = this.threadLocale.getLocale();
        String key = Utils.checkForCGLIB(entity.getClass()).toString() + "locale:" + locale;
        ClassValidator validator = (ClassValidator)classValidator.get(key);
        if (validator == null) {
            validator = this.initializeCache(key, entity, locale);
        }
        if ((invalidValues = validator.getInvalidValues(entity)).length > 0) {
            throw new InvalidStateException(invalidValues);
        }
    }

    private ClassValidator initializeCache(String key, Object entity, Locale locale) {
        Class entityClass = Utils.checkForCGLIB(entity.getClass());
        ClassValidator validator = locale == null ? new ClassValidator(entityClass) : new ClassValidator(entityClass, (MessageInterpolator)this.messageInterpolator);
        classValidator.put(key, validator);
        return validator;
    }

    private class TynamoMessageInterpolator
    implements MessageInterpolator {
        private TynamoMessageInterpolator() {
        }

        public String interpolate(String key, Validator validator, MessageInterpolator messageInterpolator) {
            return key;
        }
    }
}

