/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.hibernate.pages;

import org.apache.tapestry5.ValidationException;
import org.apache.tapestry5.annotations.Component;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.beaneditor.BeanModel;
import org.apache.tapestry5.corelib.components.Form;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.hibernate.validator.InvalidStateException;
import org.slf4j.Logger;
import org.tynamo.FlashMessage;
import org.tynamo.components.Flash;
import org.tynamo.descriptor.TynamoClassDescriptor;
import org.tynamo.hibernate.pages.HibernateModelPage;
import org.tynamo.hibernate.validation.HibernateClassValidatorFactory;
import org.tynamo.hibernate.validation.HibernateValidationDelegate;

public abstract class HibernateEditPage
extends HibernateModelPage {
    @Inject
    private Logger logger;
    @Component
    private Form form;
    @Component
    private Flash flash;
    private boolean shouldStayHere;
    @Inject
    private HibernateClassValidatorFactory hibernateClassValidatorFactory;
    @Inject
    private HibernateValidationDelegate hibernateValidationDelegate;

    public Form getForm() {
        return this.form;
    }

    void pageLoaded() {
    }

    protected void activate(Object bean, TynamoClassDescriptor classDescriptor, BeanModel beanModel) {
        this.shouldStayHere = false;
        super.activate(bean, classDescriptor, beanModel);
    }

    @Log
    protected void onValidateFormFromForm() throws ValidationException {
        try {
            this.hibernateClassValidatorFactory.validateEntity(this.getBean());
        }
        catch (InvalidStateException ise) {
            this.hibernateValidationDelegate.record(this.getClassDescriptor(), ise, this.getForm().getDefaultTracker(), this.getMessages());
        }
    }

    void onApply() {
        this.shouldStayHere = true;
    }

    @Log
    protected Object onSuccess() {
        try {
            this.getPersitenceService().save(this.getBean());
            if (this.shouldStayHere) {
                this.flash.addFlashByKey(this.getSuccessMessageKey(), FlashMessage.MessageType.SUCCESS, new Object[]{this.getBean()});
                return this;
            }
            return this.back();
        }
        catch (InvalidStateException ise) {
            this.hibernateValidationDelegate.record(this.getClassDescriptor(), ise, this.getForm().getDefaultTracker(), this.getMessages());
        }
        catch (Exception e) {
            this.getForm().recordError(e.getMessage());
            this.logger.error(e.getMessage());
            e.printStackTrace();
        }
        return null;
    }

    protected BeanModel createBeanModel(Class clazz) {
        return this.getBeanModelSource().createEditModel(clazz, this.getMessages());
    }

    protected String getSuccessMessageKey() {
        return "org.tynamo.i18n.saved";
    }
}

