/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.hibernate.services;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.tapestry5.hibernate.HibernateSessionManager;
import org.hibernate.Criteria;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.TransientObjectException;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.tynamo.descriptor.CollectionDescriptor;
import org.tynamo.descriptor.TynamoClassDescriptor;
import org.tynamo.descriptor.TynamoPropertyDescriptor;
import org.tynamo.hibernate.services.HibernatePersistenceService;
import org.tynamo.hibernate.services.QueryParameter;
import org.tynamo.services.DescriptorService;
import org.tynamo.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernatePersistenceServiceImpl
implements HibernatePersistenceService {
    private Logger logger;
    private DescriptorService descriptorService;
    private Session session;
    private HibernateSessionManager sessionManager;

    public HibernatePersistenceServiceImpl(Logger logger, DescriptorService descriptorService, Session session, HibernateSessionManager sessionManager) {
        this.logger = logger;
        this.descriptorService = descriptorService;
        this.session = session;
        this.sessionManager = sessionManager;
    }

    @Override
    public <T> T getInstance(Class<T> type, DetachedCriteria detachedCriteria) {
        DetachedCriteria criteria = this.alterCriteria(type, detachedCriteria);
        return (T)criteria.getExecutableCriteria(this.sessionManager.getSession()).uniqueResult();
    }

    public <T> T getInstance(Class<T> type, Serializable id) {
        DetachedCriteria criteria = DetachedCriteria.forClass((Class)Utils.checkForCGLIB(type)).add(Restrictions.idEq((Object)id));
        return this.getInstance(type, criteria);
    }

    public <T> T loadInstance(Class<T> type, Serializable id) {
        return (T)this.session.load(type, id);
    }

    @Override
    public List findByQuery(String queryString) {
        return this.findByQuery(queryString, new QueryParameter[0]);
    }

    @Override
    public List findByQuery(String queryString, QueryParameter ... parameters) {
        return this.findByQuery(queryString, 0, 0, parameters);
    }

    @Override
    public List findByQuery(String queryString, int startIndex, int maxResults, QueryParameter ... parameters) {
        Query query = this.session.createQuery(queryString);
        for (QueryParameter parameter : parameters) {
            parameter.applyNamedParameterToQuery(query);
        }
        if (maxResults > 0) {
            query.setMaxResults(maxResults);
        }
        if (startIndex > 0) {
            query.setFirstResult(startIndex);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(query.getQueryString());
        }
        return query.list();
    }

    public <T> List<T> getInstances(Class<T> type) {
        return this.session.createCriteria(type).list();
    }

    public <T> List<T> getInstances(Class<T> type, int startIndex, int maxResults) {
        return this.getInstances(type, DetachedCriteria.forClass(type), startIndex, maxResults);
    }

    @Override
    public <T> T save(T instance) {
        TynamoClassDescriptor TynamoClassDescriptor2 = this.descriptorService.getClassDescriptor(instance.getClass());
        if (!TynamoClassDescriptor2.getHasCyclicRelationships() || this.isTransient(instance, TynamoClassDescriptor2)) {
            this.session.saveOrUpdate(instance);
        } else {
            instance = this.session.merge(instance);
        }
        return instance;
    }

    public void removeAll(Collection collection) {
    }

    @Override
    public void remove(Object instance) {
        this.session.delete(instance);
    }

    @Override
    public <T> List<T> getInstances(Class<T> type, DetachedCriteria criteria) {
        criteria = this.alterCriteria(type, criteria);
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return criteria.getExecutableCriteria(this.sessionManager.getSession()).list();
    }

    @Override
    public void reattach(Object model) {
        this.session.lock(model, LockMode.NONE);
    }

    public <T> T getInstance(Class<T> type) {
        return this.getInstance(type, DetachedCriteria.forClass(type));
    }

    public Serializable getIdentifier(Object data, TynamoClassDescriptor classDescriptor) {
        return Integer.valueOf(0);
    }

    public boolean isTransient(Object data, TynamoClassDescriptor classDescriptor) {
        try {
            return this.getIdentifier(data, classDescriptor) == null;
        }
        catch (TransientObjectException e) {
            return true;
        }
    }

    public List getInstances(Object example, TynamoClassDescriptor classDescriptor) {
        DetachedCriteria searchCriteria = DetachedCriteria.forClass((Class)Utils.checkForCGLIB(example.getClass()));
        searchCriteria = this.alterCriteria(example.getClass(), searchCriteria);
        for (TynamoPropertyDescriptor propertyDescriptor : classDescriptor.getPropertyDescriptors()) {
            CollectionDescriptor collectionDescriptor;
            TynamoClassDescriptor collectionClassDescriptor;
            if (!propertyDescriptor.isSearchable()) continue;
            String propertyName = propertyDescriptor.getName();
            Class propertyClass = propertyDescriptor.getPropertyType();
            Object value = null;
            if (value == null) continue;
            if (String.class.isAssignableFrom(propertyClass) && ((String)value).length() > 0) {
                searchCriteria.add((Criterion)Restrictions.like((String)propertyName, (String)value.toString(), (MatchMode)MatchMode.ANYWHERE));
                continue;
            }
            if (propertyDescriptor.isObjectReference()) {
                Serializable identifierValue = this.getIdentifier(value, this.descriptorService.getClassDescriptor(propertyDescriptor.getBeanType()));
                searchCriteria.createCriteria(propertyName).add(Restrictions.idEq((Object)identifierValue));
                continue;
            }
            if (propertyClass.isPrimitive()) {
                if (propertyClass.equals(Boolean.TYPE) || ((Number)value).longValue() == 0L) continue;
                searchCriteria.add((Criterion)Restrictions.eq((String)propertyName, (Object)value));
                continue;
            }
            if (!propertyDescriptor.isCollection() || (collectionClassDescriptor = this.descriptorService.getClassDescriptor((collectionDescriptor = (CollectionDescriptor)propertyDescriptor).getElementType())) == null) continue;
            String identifierName = collectionClassDescriptor.getIdentifierDescriptor().getName();
            ArrayList<Serializable> identifierValues = new ArrayList<Serializable>();
            Collection associatedItems = (Collection)value;
            if (associatedItems == null || associatedItems.size() <= 0) continue;
            for (Object o : associatedItems) {
                identifierValues.add(this.getIdentifier(o, collectionClassDescriptor));
            }
            searchCriteria.createCriteria(propertyName).add(Restrictions.in((String)identifierName, identifierValues));
        }
        searchCriteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return searchCriteria.getExecutableCriteria(this.sessionManager.getSession()).list();
    }

    @Override
    public int count(Class type, DetachedCriteria detachedCriteria) {
        detachedCriteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        DetachedCriteria criteria = this.alterCriteria(type, detachedCriteria);
        Criteria executableCriteria = criteria.getExecutableCriteria(this.sessionManager.getSession()).setProjection(Projections.rowCount());
        return (Integer)executableCriteria.uniqueResult();
    }

    @Override
    public <T> List<T> getInstances(Class<T> type, DetachedCriteria detachedCriteria, int startIndex, int maxResults) {
        return this.getInstances(this.alterCriteria(type, detachedCriteria), startIndex, maxResults);
    }

    public List getInstances(DetachedCriteria detachedCriteria, int startIndex, int maxResults) {
        detachedCriteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        Criteria executableCriteria = detachedCriteria.getExecutableCriteria(this.sessionManager.getSession());
        if (startIndex >= 0) {
            executableCriteria.setFirstResult(startIndex);
        }
        if (maxResults > 0) {
            executableCriteria.setMaxResults(maxResults);
        }
        return executableCriteria.list();
    }

    protected DetachedCriteria alterCriteria(Class type, DetachedCriteria detachedCriteria) {
        return detachedCriteria;
    }

    @Override
    public <T> T merge(T instance) {
        return (T)this.session.merge(instance);
    }

    @Override
    public <T> T saveOrUpdate(T instance) {
        this.session.saveOrUpdate(instance);
        return instance;
    }

    public <T> T saveCollectionElement(String addExpression, T member, Object parent) {
        T instance = this.save(member);
        Utils.executeOgnlExpression((String)addExpression, member, (Object)parent);
        this.save(parent);
        return instance;
    }

    public void removeCollectionElement(String removeExpression, Object member, Object parent) {
        Utils.executeOgnlExpression((String)removeExpression, (Object)member, (Object)parent);
        this.save(parent);
        this.remove(member);
    }
}

