/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.hibernate;

import java.util.Collection;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.type.Type;

public class QueryParameter {
    private String name;
    private Object value;
    private Type type;

    public QueryParameter(String name, Object value) {
        this(name, value, null);
    }

    public QueryParameter(String name, Object value, Type type) {
        this.name = name;
        this.value = value;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public QueryParameter(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public void applyNamedParameterToQuery(Query queryObject) throws HibernateException {
        if (this.value instanceof Collection) {
            if (this.type != null) {
                queryObject.setParameterList(this.name, (Collection)this.value, this.type);
            } else {
                queryObject.setParameterList(this.name, (Collection)this.value);
            }
        } else if (this.value instanceof Object[]) {
            if (this.type != null) {
                queryObject.setParameterList(this.name, (Object[])this.value, this.type);
            } else {
                queryObject.setParameterList(this.name, (Object[])this.value);
            }
        } else if (this.type != null) {
            queryObject.setParameter(this.name, this.value, this.type);
        } else {
            queryObject.setParameter(this.name, this.value);
        }
    }
}

