/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.hibernate.v4;

import java.util.List;
import org.apache.tapestry5.hibernate.HibernateConfigurer;
import org.apache.tapestry5.hibernate.HibernateSessionSource;
import org.apache.tapestry5.internal.hibernate.HibernateCoreMessages;
import org.apache.tapestry5.ioc.annotations.PostInjection;
import org.apache.tapestry5.ioc.services.RegistryShutdownHub;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.slf4j.Logger;

public class Hibernate4SessionSourceImpl
implements HibernateSessionSource {
    private final SessionFactory sessionFactory;
    private final Configuration configuration;

    public Hibernate4SessionSourceImpl(Logger logger, List<HibernateConfigurer> hibernateConfigurers) {
        long startTime = System.currentTimeMillis();
        this.configuration = new Configuration();
        for (HibernateConfigurer configurer : hibernateConfigurers) {
            configurer.configure(this.configuration);
        }
        long configurationComplete = System.currentTimeMillis();
        this.sessionFactory = this.configuration.buildSessionFactory();
        long factoryCreated = System.currentTimeMillis();
        logger.info(HibernateCoreMessages.startupTiming((long)(configurationComplete - startTime), (long)(factoryCreated - startTime)));
        logger.info(HibernateCoreMessages.entityCatalog(this.sessionFactory.getAllClassMetadata().keySet()));
    }

    @PostInjection
    public void listenForShutdown(RegistryShutdownHub hub) {
        hub.addRegistryShutdownListener(new Runnable(){

            @Override
            public void run() {
                Hibernate4SessionSourceImpl.this.sessionFactory.close();
            }
        });
    }

    public Session create() {
        return this.sessionFactory.openSession();
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }
}

