/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.hibernate;

import java.util.List;
import java.util.Map;
import org.apache.tapestry5.grid.GridDataSource;
import org.apache.tapestry5.grid.SortConstraint;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.search.FullTextQuery;
import org.tynamo.descriptor.TynamoPropertyDescriptor;
import org.tynamo.search.SearchFilterPredicate;

public class SearchableHibernateGridDataSource
implements GridDataSource {
    private FullTextQuery fullTextQuery;
    private Map<TynamoPropertyDescriptor, SearchFilterPredicate> propertySearchFilterMap;
    private Session session;
    private Class entityType;
    private int startIndex;
    private List preparedResults;

    public SearchableHibernateGridDataSource(Session session, Class entityType, Map<TynamoPropertyDescriptor, SearchFilterPredicate> propertySearchFilterMap) {
        this(session, entityType, null, propertySearchFilterMap);
    }

    public SearchableHibernateGridDataSource(Session session, Class entityType, FullTextQuery fullTextQuery, Map<TynamoPropertyDescriptor, SearchFilterPredicate> propertySearchFilterMap) {
        this.session = session;
        this.entityType = entityType;
        this.fullTextQuery = fullTextQuery;
        this.propertySearchFilterMap = propertySearchFilterMap;
    }

    public int getAvailableRows() {
        Criteria criteria = this.session.createCriteria(this.entityType);
        this.applyAdditionalConstraints(criteria);
        if (this.fullTextQuery == null) {
            criteria.setProjection(Projections.rowCount());
            Number result = (Number)criteria.uniqueResult();
            return result.intValue();
        }
        this.fullTextQuery.setCriteriaQuery(criteria);
        return this.fullTextQuery.list().size();
    }

    public void prepare(int startIndex, int endIndex, List<SortConstraint> sortConstraints) {
        assert (sortConstraints != null);
        Criteria crit = this.session.createCriteria(this.entityType);
        crit.setFirstResult(startIndex).setMaxResults(endIndex - startIndex + 1);
        for (SortConstraint constraint : sortConstraints) {
            String propertyName = constraint.getPropertyModel().getPropertyName();
            switch (constraint.getColumnSort()) {
                case ASCENDING: {
                    crit.addOrder(Order.asc((String)propertyName));
                    break;
                }
                case DESCENDING: {
                    crit.addOrder(Order.desc((String)propertyName));
                    break;
                }
            }
        }
        this.applyAdditionalConstraints(crit);
        this.startIndex = startIndex;
        if (this.fullTextQuery == null) {
            this.preparedResults = crit.list();
            return;
        }
        this.fullTextQuery.setCriteriaQuery(crit);
        this.preparedResults = this.fullTextQuery.list();
    }

    protected void applyAdditionalConstraints(Criteria crit) {
        if (this.propertySearchFilterMap == null || this.propertySearchFilterMap.size() <= 0) {
            return;
        }
        for (Map.Entry<TynamoPropertyDescriptor, SearchFilterPredicate> entry : this.propertySearchFilterMap.entrySet()) {
            crit.add(this.createCriterion(entry.getKey().getName(), entry.getValue()));
        }
    }

    private Criterion createCriterion(String propertyName, SearchFilterPredicate predicate) {
        switch (predicate.getOperator()) {
            case eq: {
                return Restrictions.eq((String)propertyName, (Object)predicate.getLowValue());
            }
            case ne: {
                return Restrictions.ne((String)propertyName, (Object)predicate.getLowValue());
            }
            case gt: {
                return Restrictions.gt((String)propertyName, (Object)predicate.getLowValue());
            }
            case ge: {
                return Restrictions.ge((String)propertyName, (Object)predicate.getLowValue());
            }
            case lt: {
                return Restrictions.lt((String)propertyName, (Object)predicate.getLowValue());
            }
            case le: {
                return Restrictions.le((String)propertyName, (Object)predicate.getLowValue());
            }
        }
        throw new IllegalArgumentException("Search filtering for operator '" + predicate.getOperator() + "' is not yet supported");
    }

    public Object getRowValue(int index) {
        return this.preparedResults.get(index - this.startIndex);
    }

    public Class getRowType() {
        return this.entityType;
    }
}

