/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.hibernate.decorators;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import javax.persistence.OneToMany;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Flow;
import org.apache.tapestry5.func.Predicate;
import org.apache.tapestry5.hibernate.HibernateSessionSource;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.metadata.CollectionMetadata;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ComponentType;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.tynamo.descriptor.CollectionDescriptor;
import org.tynamo.descriptor.EmbeddedDescriptor;
import org.tynamo.descriptor.IdentifierDescriptor;
import org.tynamo.descriptor.IdentifierDescriptorImpl;
import org.tynamo.descriptor.ObjectReferenceDescriptor;
import org.tynamo.descriptor.TynamoClassDescriptor;
import org.tynamo.descriptor.TynamoPropertyDescriptor;
import org.tynamo.descriptor.decorators.DescriptorDecorator;
import org.tynamo.descriptor.extension.DescriptorExtension;
import org.tynamo.descriptor.extension.EnumReferenceDescriptor;
import org.tynamo.descriptor.factories.DescriptorFactory;
import org.tynamo.exception.MetadataNotFoundException;
import org.tynamo.exception.TynamoRuntimeException;

public class HibernateDescriptorDecorator
implements DescriptorDecorator {
    private Logger logger;
    private HibernateSessionSource hibernateSessionSource;
    private DescriptorFactory descriptorFactory;
    private final int largeColumnLength;
    private final boolean ignoreNonHibernateTypes;

    public HibernateDescriptorDecorator(HibernateSessionSource hibernateSessionSource, DescriptorFactory descriptorFactory, @Inject @Symbol(value="tynamo.hibernate.large-column-length") int largeColumnLength, @Inject @Symbol(value="tynamo.hibernate.ignore-non-hibernate-types") boolean ignoreNonHibernateTypes, Logger logger) {
        this.hibernateSessionSource = hibernateSessionSource;
        this.descriptorFactory = descriptorFactory;
        this.largeColumnLength = largeColumnLength;
        this.ignoreNonHibernateTypes = ignoreNonHibernateTypes;
        this.logger = logger;
    }

    public TynamoClassDescriptor decorate(TynamoClassDescriptor descriptor) {
        ArrayList<IdentifierDescriptor> decoratedPropertyDescriptors = new ArrayList<IdentifierDescriptor>();
        Class beanType = descriptor.getBeanType();
        ClassMetadata classMetaData = null;
        try {
            classMetaData = this.findMetadata(beanType);
        }
        catch (MetadataNotFoundException e) {
            if (this.ignoreNonHibernateTypes) {
                this.logger.warn("MetadataNotFound! could not decorate: " + descriptor.getBeanType().getSimpleName());
                descriptor.setNonVisual(true);
                return descriptor;
            }
            throw new TynamoRuntimeException((Throwable)((Object)e));
        }
        for (TynamoPropertyDescriptor propertyDescriptor : descriptor.getPropertyDescriptors()) {
            try {
                IdentifierDescriptor descriptorReference;
                if (propertyDescriptor.getName().equals(this.getIdentifierProperty(beanType))) {
                    descriptorReference = this.createIdentifierDescriptor(beanType, propertyDescriptor);
                } else if (this.notAHibernateProperty(classMetaData, propertyDescriptor)) {
                    propertyDescriptor.setSearchable(false);
                    descriptorReference = propertyDescriptor;
                } else {
                    Property mappingProperty = this.getMapping(beanType).getProperty(propertyDescriptor.getName());
                    descriptorReference = this.decoratePropertyDescriptor(beanType, mappingProperty, propertyDescriptor);
                }
                decoratedPropertyDescriptors.add(descriptorReference);
            }
            catch (HibernateException e) {
                throw new TynamoRuntimeException((Throwable)e);
            }
        }
        descriptor.setPropertyDescriptors(decoratedPropertyDescriptors);
        return descriptor;
    }

    protected TynamoPropertyDescriptor decoratePropertyDescriptor(Class beanType, Property mappingProperty, TynamoPropertyDescriptor descriptor) {
        if (this.isFormula(mappingProperty)) {
            descriptor.setReadOnly(true);
            return descriptor;
        }
        descriptor.setLength(this.findColumnLength(mappingProperty));
        descriptor.setLarge(this.isLarge(mappingProperty));
        if (!mappingProperty.isOptional()) {
            descriptor.setRequired(true);
        }
        if (!mappingProperty.isInsertable() && !mappingProperty.isUpdateable()) {
            descriptor.setReadOnly(true);
        }
        TynamoPropertyDescriptor descriptorReference = descriptor;
        Type hibernateType = mappingProperty.getType();
        if (mappingProperty.getType() instanceof ComponentType) {
            descriptorReference = this.buildEmbeddedDescriptor(beanType, mappingProperty, descriptor);
        } else if (mappingProperty.getType() instanceof CollectionType) {
            descriptorReference = this.decorateCollectionDescriptor(beanType, descriptor);
        } else if (hibernateType.isAssociationType()) {
            descriptorReference = this.decorateAssociationDescriptor(beanType, mappingProperty, descriptor);
        } else if (hibernateType.getReturnedClass().isEnum()) {
            descriptor.addExtension(EnumReferenceDescriptor.class.getName(), (DescriptorExtension)new EnumReferenceDescriptor(hibernateType.getReturnedClass()));
        }
        return descriptorReference;
    }

    private EmbeddedDescriptor buildEmbeddedDescriptor(Class beanType, Property mappingProperty, TynamoPropertyDescriptor descriptor) {
        Component componentMapping = (Component)mappingProperty.getValue();
        TynamoClassDescriptor embeddedClassDescriptor = this.descriptorFactory.buildClassDescriptor(descriptor.getPropertyType());
        ArrayList<TynamoPropertyDescriptor> decoratedProperties = new ArrayList<TynamoPropertyDescriptor>();
        for (TynamoPropertyDescriptor propertyDescriptor : embeddedClassDescriptor.getPropertyDescriptors()) {
            if (this.notAHibernateProperty(componentMapping, propertyDescriptor)) {
                decoratedProperties.add(propertyDescriptor);
                continue;
            }
            Property property = componentMapping.getProperty(propertyDescriptor.getName());
            TynamoPropertyDescriptor tynamopropertydescriptor = this.decoratePropertyDescriptor(embeddedClassDescriptor.getBeanType(), property, propertyDescriptor);
            decoratedProperties.add(tynamopropertydescriptor);
        }
        embeddedClassDescriptor.setPropertyDescriptors(decoratedProperties);
        return new EmbeddedDescriptor(beanType, descriptor, embeddedClassDescriptor);
    }

    protected ClassMetadata findMetadata(Class type) throws MetadataNotFoundException {
        ClassMetadata metaData = this.hibernateSessionSource.getSessionFactory().getClassMetadata(type);
        if (metaData != null) {
            return metaData;
        }
        if (!type.equals(Object.class)) {
            return this.findMetadata(type.getSuperclass());
        }
        throw new MetadataNotFoundException("Failed to find metadata.");
    }

    private boolean isFormula(Property mappingProperty) {
        Iterator iter = mappingProperty.getColumnIterator();
        while (iter.hasNext()) {
            Selectable selectable = (Selectable)iter.next();
            if (!selectable.isFormula()) continue;
            return true;
        }
        return false;
    }

    protected boolean notAHibernateProperty(Component componentMapping, TynamoPropertyDescriptor propertyDescriptor) {
        Iterator iter = componentMapping.getPropertyIterator();
        while (iter.hasNext()) {
            Property property = (Property)iter.next();
            if (!property.getName().equals(propertyDescriptor.getName())) continue;
            return false;
        }
        return true;
    }

    private boolean isLarge(Property mappingProperty) {
        return this.findColumnLength(mappingProperty) != 255 && this.findColumnLength(mappingProperty) > this.largeColumnLength;
    }

    private int findColumnLength(Property mappingProperty) {
        int length = 0;
        Iterator iter = mappingProperty.getColumnIterator();
        while (iter.hasNext()) {
            Column column = (Column)iter.next();
            length += column.getLength();
        }
        return length;
    }

    protected boolean notAHibernateProperty(ClassMetadata classMetaData, final TynamoPropertyDescriptor descriptor) {
        return ((Flow)F.flow((Object[])classMetaData.getPropertyNames()).filter((Predicate)new Predicate<String>(){

            public boolean accept(String propertyName) {
                return descriptor.getName().equals(propertyName);
            }
        })).isEmpty();
    }

    private IdentifierDescriptor createIdentifierDescriptor(Class beanType, TynamoPropertyDescriptor descriptor) {
        IdentifierDescriptorImpl identifierDescriptor;
        PersistentClass mapping = this.getMapping(beanType);
        if (mapping.getProperty(descriptor.getName()).getType() instanceof ComponentType) {
            EmbeddedDescriptor embeddedDescriptor = this.buildEmbeddedDescriptor(beanType, mapping.getProperty(descriptor.getName()), descriptor);
            embeddedDescriptor.setIdentifier(true);
            identifierDescriptor = embeddedDescriptor;
        } else {
            identifierDescriptor = new IdentifierDescriptorImpl(beanType, descriptor);
        }
        if (((SimpleValue)mapping.getIdentifier()).getIdentifierGeneratorStrategy().equals("assigned")) {
            identifierDescriptor.setGenerated(false);
        }
        return identifierDescriptor;
    }

    protected PersistentClass getMapping(Class type) {
        Configuration cfg = this.hibernateSessionSource.getConfiguration();
        return cfg.getClassMapping(type.getName());
    }

    private CollectionDescriptor decorateCollectionDescriptor(Class beanType, TynamoPropertyDescriptor descriptor) {
        try {
            CollectionDescriptor collectionDescriptor = new CollectionDescriptor(beanType, descriptor);
            Collection collectionMapping = this.findCollectionMapping(beanType, descriptor.getName());
            collectionDescriptor.setChildRelationship(collectionMapping.hasOrphanDelete());
            CollectionMetadata collectionMetaData = this.hibernateSessionSource.getSessionFactory().getCollectionMetadata(collectionMapping.getRole());
            collectionDescriptor.setElementType(collectionMetaData.getElementType().getReturnedClass());
            collectionDescriptor.setOneToMany(collectionMapping.isOneToMany());
            this.decorateOneToManyCollection(beanType, collectionDescriptor, collectionMapping);
            return collectionDescriptor;
        }
        catch (HibernateException e) {
            throw new TynamoRuntimeException((Throwable)e);
        }
    }

    public TynamoPropertyDescriptor decorateAssociationDescriptor(Class beanType, Property mappingProperty, TynamoPropertyDescriptor descriptor) {
        Type hibernateType = mappingProperty.getType();
        return new ObjectReferenceDescriptor(beanType, descriptor, hibernateType.getReturnedClass());
    }

    private void decorateOneToManyCollection(Class beanType, final CollectionDescriptor descriptor, Collection mapping) {
        if (descriptor.isOneToMany() && mapping.isInverse()) {
            try {
                Field propertyField = beanType.getDeclaredField(descriptor.getName());
                Object[] propertyDescriptors = Introspector.getBeanInfo(beanType).getPropertyDescriptors();
                PropertyDescriptor beanPropDescriptor = (PropertyDescriptor)((Flow)F.flow((Object[])propertyDescriptors).filter((Predicate)new Predicate<PropertyDescriptor>(){

                    public boolean accept(PropertyDescriptor propertyDescriptor) {
                        return propertyDescriptor.getName().equals(descriptor.getName());
                    }
                })).first();
                Method readMethod = beanPropDescriptor.getReadMethod();
                String mappedBy = "";
                if (readMethod.isAnnotationPresent(OneToMany.class)) {
                    mappedBy = readMethod.getAnnotation(OneToMany.class).mappedBy();
                } else if (propertyField.isAnnotationPresent(OneToMany.class)) {
                    mappedBy = propertyField.getAnnotation(OneToMany.class).mappedBy();
                }
                if (!"".equals(mappedBy)) {
                    descriptor.setInverseProperty(mappedBy);
                }
            }
            catch (SecurityException e) {
                this.logger.warn("Couldn't decorate collection: " + beanType.getSimpleName() + "." + descriptor.getName(), (Throwable)e);
            }
            catch (NoSuchFieldException e) {
                this.logger.warn("Couldn't decorate collection: " + beanType.getSimpleName() + "." + descriptor.getName(), (Throwable)e);
            }
            catch (IntrospectionException e) {
                this.logger.warn("Couldn't decorate collection: " + beanType.getSimpleName() + "." + descriptor.getName(), (Throwable)e);
            }
        }
    }

    protected Collection findCollectionMapping(Class type, String name) {
        String roleName = type.getName() + "." + name;
        Collection collectionMapping = this.hibernateSessionSource.getConfiguration().getCollectionMapping(roleName);
        if (collectionMapping != null) {
            return collectionMapping;
        }
        if (!type.equals(Object.class)) {
            return this.findCollectionMapping(type.getSuperclass(), name);
        }
        throw new MetadataNotFoundException("Metadata not found.");
    }

    public String getIdentifierProperty(Class type) {
        try {
            return this.hibernateSessionSource.getSessionFactory().getClassMetadata(type).getIdentifierPropertyName();
        }
        catch (HibernateException e) {
            throw new TynamoRuntimeException((Throwable)e);
        }
    }
}

