/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.hibernate.decorators;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Flow;
import org.apache.tapestry5.func.Predicate;
import org.hibernate.search.annotations.Indexed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tynamo.descriptor.TynamoClassDescriptor;
import org.tynamo.descriptor.TynamoPropertyDescriptor;
import org.tynamo.descriptor.decorators.DescriptorDecorator;

public class HibernateSearchDescriptorDecorator
implements DescriptorDecorator {
    private static final Logger LOGGER = LoggerFactory.getLogger(HibernateSearchDescriptorDecorator.class);

    public TynamoClassDescriptor decorate(TynamoClassDescriptor descriptor) {
        PropertyDescriptor[] propertyDescriptors;
        Class type = descriptor.getBeanType();
        if (!type.isAnnotationPresent(Indexed.class)) {
            return descriptor;
        }
        descriptor.setSearchable(true);
        try {
            propertyDescriptors = Introspector.getBeanInfo(type).getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            LOGGER.warn(ExceptionUtils.getRootCauseMessage((Throwable)e));
            return descriptor;
        }
        for (TynamoPropertyDescriptor propertyDescriptor : descriptor.getPropertyDescriptors()) {
            try {
                Field propertyField = propertyDescriptor.getBeanType().getDeclaredField(propertyDescriptor.getName());
                if (propertyField.isAnnotationPresent(org.hibernate.search.annotations.Field.class)) {
                    propertyDescriptor.setSearchable(true);
                    continue;
                }
            }
            catch (Exception ex) {
                LOGGER.warn(ExceptionUtils.getRootCauseMessage((Throwable)ex));
            }
            try {
                if (!this.isAnnotationPresent(propertyDescriptors, propertyDescriptor, org.hibernate.search.annotations.Field.class)) continue;
                propertyDescriptor.setSearchable(true);
            }
            catch (Exception ex) {
                LOGGER.warn(ExceptionUtils.getRootCauseMessage((Throwable)ex));
            }
        }
        return descriptor;
    }

    private boolean isAnnotationPresent(PropertyDescriptor[] descriptors, final TynamoPropertyDescriptor tynamoPropertyDescriptor, Class<? extends Annotation> annotation) {
        try {
            PropertyDescriptor beanPropDescriptor = (PropertyDescriptor)((Flow)F.flow((Object[])descriptors).filter((Predicate)new Predicate<PropertyDescriptor>(){

                public boolean accept(PropertyDescriptor descriptor) {
                    return descriptor.getName().equals(tynamoPropertyDescriptor.getName());
                }
            })).first();
            if (beanPropDescriptor == null) {
                return false;
            }
            Method readMethod = beanPropDescriptor.getReadMethod();
            return readMethod.isAnnotationPresent(annotation);
        }
        catch (Exception ex) {
            LOGGER.warn(ExceptionUtils.getRootCauseMessage((Throwable)ex));
            return false;
        }
    }
}

