/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.hibernate.services;

import java.util.Iterator;
import org.apache.tapestry5.hibernate.HibernateConfigurer;
import org.apache.tapestry5.hibernate.HibernateSessionSource;
import org.apache.tapestry5.hibernate.HibernateTransactionAdvisor;
import org.apache.tapestry5.ioc.Configuration;
import org.apache.tapestry5.ioc.MappedConfiguration;
import org.apache.tapestry5.ioc.MethodAdviceReceiver;
import org.apache.tapestry5.ioc.OrderedConfiguration;
import org.apache.tapestry5.ioc.ServiceBinder;
import org.apache.tapestry5.ioc.annotations.Autobuild;
import org.apache.tapestry5.ioc.annotations.Contribute;
import org.apache.tapestry5.ioc.annotations.InjectService;
import org.apache.tapestry5.ioc.annotations.Match;
import org.apache.tapestry5.ioc.services.FactoryDefaults;
import org.apache.tapestry5.ioc.services.SymbolProvider;
import org.apache.tapestry5.services.BeanBlockContribution;
import org.apache.tapestry5.services.BeanBlockSource;
import org.apache.tapestry5.services.ClasspathAssetAliasManager;
import org.apache.tapestry5.services.ComponentClassResolver;
import org.apache.tapestry5.services.LibraryMapping;
import org.apache.tapestry5.services.messages.ComponentMessagesSource;
import org.hibernate.mapping.PersistentClass;
import org.tynamo.common.ModuleProperties;
import org.tynamo.descriptor.decorators.DescriptorDecorator;
import org.tynamo.descriptor.factories.DescriptorFactory;
import org.tynamo.hibernate.TynamoInterceptor;
import org.tynamo.hibernate.TynamoInterceptorConfigurer;
import org.tynamo.hibernate.decorators.HibernateDescriptorDecorator;
import org.tynamo.hibernate.services.HibernatePersistenceService;
import org.tynamo.hibernate.services.HibernatePersistenceServiceImpl;
import org.tynamo.services.DescriptorService;
import org.tynamo.services.TynamoCoreModule;

public class TynamoHibernateModule {
    private static final String version = ModuleProperties.getVersion(TynamoCoreModule.class);

    public static void bind(ServiceBinder binder) {
        binder.bind(HibernatePersistenceService.class, HibernatePersistenceServiceImpl.class);
        binder.bind(TynamoInterceptor.class);
        binder.bind(HibernateConfigurer.class, TynamoInterceptorConfigurer.class).withId("TynamoInterceptorConfigurer");
    }

    @Contribute(value=ComponentClassResolver.class)
    public static void componentClassResolver(Configuration<LibraryMapping> configuration) {
        configuration.add((Object)new LibraryMapping("tynamo", "org.tynamo.hibernate"));
    }

    @Contribute(value=ClasspathAssetAliasManager.class)
    public static void classpathAssetAliasManager(MappedConfiguration<String, String> configuration) {
        configuration.add((Object)("tynamo-hibernate-" + version), (Object)"org/tynamo/hibernate");
    }

    @Contribute(value=ComponentMessagesSource.class)
    public static void componentMessagesSource(OrderedConfiguration<String> configuration) {
        configuration.add("Tynamo", (Object)"ValidationMessages", new String[0]);
    }

    @Match(value={"HibernatePersistenceService"})
    public static void adviseTransactions(HibernateTransactionAdvisor advisor, MethodAdviceReceiver receiver) {
        advisor.addTransactionCommitAdvice(receiver);
    }

    public static void contributeDefaultDataTypeAnalyzer(MappedConfiguration<Class, String> configuration) {
    }

    @Contribute(value=BeanBlockSource.class)
    public static void beanBlockSource(Configuration<BeanBlockContribution> configuration) {
    }

    @Contribute(value=DescriptorFactory.class)
    public static void descriptorFactory(OrderedConfiguration<DescriptorDecorator> configuration, @Autobuild HibernateDescriptorDecorator hibernateDescriptorDecorator) {
        configuration.add("HibernateDescriptorDecorator", (Object)hibernateDescriptorDecorator, new String[]{"after:TynamoDecorator"});
    }

    @Contribute(value=DescriptorService.class)
    public static void descriptorService(Configuration<Class> configuration, HibernateSessionSource hibernateSessionSource) {
        org.hibernate.cfg.Configuration config = hibernateSessionSource.getConfiguration();
        Iterator mappings = config.getClassMappings();
        while (mappings.hasNext()) {
            PersistentClass persistentClass = (PersistentClass)mappings.next();
            Class entityClass = persistentClass.getMappedClass();
            if (entityClass == null) continue;
            configuration.add((Object)entityClass);
        }
    }

    @Contribute(value=SymbolProvider.class)
    @FactoryDefaults
    public static void setupFactoryDefaultsSymbols(MappedConfiguration<String, String> configuration) {
        configuration.add((Object)"tynamo.hibernate.large-column-length", (Object)"100");
        configuration.add((Object)"tynamo.hibernate.ignore-non-hibernate-types", (Object)"false");
    }

    @Contribute(value=HibernateSessionSource.class)
    public static void hibernateSessionSource(OrderedConfiguration<HibernateConfigurer> config, @InjectService(value="TynamoInterceptorConfigurer") HibernateConfigurer interceptorConfigurer) {
        config.add("TynamoInterceptorConfigurer", (Object)interceptorConfigurer, new String[0]);
    }
}

