/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.test;

import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.ClickableElement;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.IOException;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.DefaultHandler;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.resource.Resource;
import org.mortbay.resource.ResourceCollection;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeTest;

public abstract class AbstractContainerTest {
    protected static PauseableServer server;
    protected static final int port = 8180;
    protected static final String BASEURI = "http://localhost:8180/";
    protected final WebClient webClient = new WebClient();
    static String errorText;

    @BeforeClass
    public static void startContainer() throws Exception {
        if (server == null) {
            server = new PauseableServer();
            SelectChannelConnector connector = new SelectChannelConnector();
            connector.setPort(8180);
            server.setConnectors(new Connector[]{connector});
            WebAppContext context = new WebAppContext("src/main/webapp", "/");
            ResourceCollection resourceCollection = new ResourceCollection(new String[]{"src/main/webapp", "src/test/webapp"});
            context.setBaseResource((Resource)resourceCollection);
            HandlerCollection handlers = new HandlerCollection();
            handlers.setHandlers(new Handler[]{context, new DefaultHandler()});
            server.setHandler((Handler)handlers);
            server.start();
            Assert.assertTrue((boolean)server.isStarted());
        }
    }

    @BeforeTest
    public void configureWebClient() {
        this.webClient.setThrowExceptionOnFailingStatusCode(true);
    }

    public void pauseServer(boolean paused) {
        if (server != null) {
            server.pause(paused);
        }
    }

    protected void assertXPathPresent(HtmlPage page, String xpath) throws Exception {
        Assert.assertNotNull(page.getByXPath(xpath).get(0));
    }

    protected void assertXPathNotPresent(HtmlPage page, String xpath) throws Exception {
        Assert.assertNull(page.getByXPath(xpath).get(0));
    }

    protected HtmlPage clickLink(HtmlPage page, String linkText) {
        try {
            return (HtmlPage)page.getFirstAnchorByText(linkText).click();
        }
        catch (ElementNotFoundException e) {
            Assert.fail((String)("Couldn't find a link with text '" + linkText + "' on page " + page));
        }
        catch (IOException e) {
            Assert.fail((String)("Clicking on link '" + linkText + "' on page " + page + " failed because of: "), (Throwable)e);
        }
        return null;
    }

    protected HtmlPage clickButton(HtmlPage page, String buttonId) throws IOException {
        ClickableElement button = (ClickableElement)page.getElementById(buttonId);
        return (HtmlPage)button.click();
    }

    protected HtmlPage clickButton(HtmlForm form, String buttonValue) throws IOException {
        try {
            return (HtmlPage)form.getInputByValue(buttonValue).click();
        }
        catch (ElementNotFoundException e) {
            try {
                return (HtmlPage)form.getButtonByName(buttonValue).click();
            }
            catch (ElementNotFoundException e1) {
                Assert.fail((String)("Couldn't find a button with text/name '" + buttonValue + "' on form '" + form.getNameAttribute() + "'"));
                return null;
            }
        }
    }

    protected void assertErrorTextPresent(HtmlPage page) {
        WebAssert.assertTextPresent((HtmlPage)page, (String)errorText);
    }

    protected void assertErrorTextNotPresent(HtmlPage page) {
        WebAssert.assertTextNotPresent((HtmlPage)page, (String)errorText);
    }

    static {
        errorText = "You must correct the following errors before you may continue";
    }

    public static class PauseableServer
    extends Server {
        public synchronized void pause(boolean paused) {
            try {
                if (paused) {
                    for (Connector connector : this.getConnectors()) {
                        connector.stop();
                    }
                } else {
                    for (Connector connector : this.getConnectors()) {
                        connector.start();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

