/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.test.functional;

import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlSubmitInput;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.testng.Assert;

public class FunctionalTest {
    WebClient webClient;
    protected HtmlPage startPage;

    public void setUp() throws Exception {
        Properties testProperties = new Properties();
        testProperties.load(this.getClass().getResourceAsStream("/functionaltest.properties"));
        this.webClient = new WebClient();
        this.setUpWebClient(this.webClient);
        this.startPage = (HtmlPage)this.webClient.getPage(new URL(testProperties.getProperty("test.url")));
    }

    protected HtmlForm getFirstForm(HtmlPage page) {
        return (HtmlForm)page.getForms().get(0);
    }

    protected HtmlPage clickButton(HtmlForm form, String buttonValue) throws IOException {
        HtmlSubmitInput button = null;
        try {
            button = (HtmlSubmitInput)form.getInputByValue(buttonValue);
        }
        catch (ElementNotFoundException e) {
            button = form.getButtonByName(buttonValue);
        }
        return (HtmlPage)button.click();
    }

    protected HtmlPage clickButton(HtmlPage page, String buttonValue) throws IOException {
        return this.clickButton((HtmlForm)page.getForms().get(0), buttonValue);
    }

    protected HtmlPage clickLinkOnPage(HtmlPage page, String linkText) throws IOException {
        return (HtmlPage)page.getFirstAnchorByText(linkText).click();
    }

    protected void assertXPathPresent(HtmlPage page, String xpath) throws Exception {
        Assert.assertNotNull(page.getByXPath(xpath).get(0));
    }

    protected void setUpWebClient(WebClient webClient) {
        webClient.setJavaScriptEnabled(false);
    }
}

