/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.security;

import java.io.IOException;
import javax.servlet.ServletRequest;
import org.apache.shiro.ShiroException;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.StringUtils;
import org.apache.shiro.web.util.WebUtils;
import org.apache.tapestry5.internal.services.PageResponseRenderer;
import org.apache.tapestry5.internal.services.RequestPageCache;
import org.apache.tapestry5.internal.structure.Page;
import org.apache.tapestry5.runtime.Component;
import org.apache.tapestry5.services.ExceptionReporter;
import org.apache.tapestry5.services.RequestGlobals;
import org.apache.tapestry5.services.Response;
import org.tynamo.security.services.PageService;
import org.tynamo.security.services.SecurityService;

public class ShiroExceptionHandler {
    private final PageResponseRenderer renderer;
    private final RequestPageCache pageCache;
    private final SecurityService securityService;
    private final PageService pageService;
    private final RequestGlobals requestGlobals;
    private final Response response;

    public ShiroExceptionHandler(PageResponseRenderer renderer, RequestPageCache pageCache, SecurityService securityService, PageService pageService, RequestGlobals requestGlobals, Response response) {
        this.renderer = renderer;
        this.pageCache = pageCache;
        this.securityService = securityService;
        this.pageService = pageService;
        this.requestGlobals = requestGlobals;
        this.response = response;
    }

    public void handle(ShiroException exception) throws IOException {
        if (this.securityService.isAuthenticated()) {
            String unauthorizedPage = this.pageService.getUnauthorizedPage();
            this.response.setStatus(401);
            if (!StringUtils.hasText((String)unauthorizedPage)) {
                return;
            }
            Page page = this.pageCache.get(unauthorizedPage);
            this.reportExceptionIfPossible(exception, page);
            this.renderer.renderPageResponse(page);
        } else {
            Session session;
            Subject subject = this.securityService.getSubject();
            if (subject != null && (session = subject.getSession()) != null) {
                WebUtils.saveRequest((ServletRequest)this.requestGlobals.getHTTPServletRequest());
            }
            Page page = this.pageCache.get(this.pageService.getLoginPage());
            this.reportExceptionIfPossible(exception, page);
            this.renderer.renderPageResponse(page);
        }
    }

    private void reportExceptionIfPossible(ShiroException exception, Page page) {
        Component rootComponent = page.getRootComponent();
        if (rootComponent instanceof ExceptionReporter) {
            ((ExceptionReporter)rootComponent).reportException((Throwable)exception);
        }
    }
}

