/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.security.filter;

import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.util.AntPathMatcher;
import org.apache.shiro.util.PatternMatcher;
import org.apache.shiro.util.StringUtils;
import org.apache.shiro.web.filter.AccessControlFilter;
import org.apache.shiro.web.filter.PathMatchingFilter;
import org.apache.shiro.web.filter.PathMatchingFilterPatternMatcherChanger;
import org.apache.shiro.web.filter.authc.AuthenticationFilter;
import org.apache.shiro.web.filter.authz.AuthorizationFilter;
import org.apache.shiro.web.filter.mgt.DefaultFilterChainManager;
import org.apache.shiro.web.filter.mgt.FilterChainManager;
import org.apache.shiro.web.filter.mgt.FilterChainResolver;
import org.apache.shiro.web.filter.mgt.PathMatchingFilterChainResolver;
import org.apache.shiro.web.mgt.WebSecurityManager;
import org.apache.shiro.web.servlet.IniShiroFilter;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.ServiceId;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.services.ApplicationGlobals;
import org.apache.tapestry5.services.HttpServletRequestFilter;
import org.apache.tapestry5.services.HttpServletRequestHandler;
import org.slf4j.Logger;
import org.tynamo.security.FilterChainDefinition;

@ServiceId(value="SecurityRequestFilter")
public class SecurityRequestFilter
extends IniShiroFilter
implements HttpServletRequestFilter {
    private IniShiroFilter shiroFilter;
    private Logger logger;
    private String loginUrl;
    private String unauthorizedUrl;
    private String successUrl;

    public SecurityRequestFilter(List<FilterChainDefinition> filterChainDefinitions, WebSecurityManager securityManager, Logger logger, @Inject @Symbol(value="security.successurl") String successUrl, @Inject @Symbol(value="security.loginurl") String loginUrl, @Inject @Symbol(value="security.unauthorizedurl") String unauthorizedUrl, @Inject @Symbol(value="security.configpath") String configPath, @Inject @Symbol(value="security.loadinifrompath") boolean shouldLoadIniFromPath, ApplicationGlobals globals) throws Exception {
        final ServletContext servletContext = globals.getServletContext();
        this.logger = logger;
        this.loginUrl = loginUrl;
        this.unauthorizedUrl = unauthorizedUrl;
        this.successUrl = successUrl;
        this.shiroFilter = new IniShiroFilter();
        if (shouldLoadIniFromPath) {
            this.shiroFilter.setConfigPath(configPath);
            this.shiroFilter.init(new FilterConfig(){

                public String getFilterName() {
                    return "ShiroFilter";
                }

                public ServletContext getServletContext() {
                    return servletContext;
                }

                public String getInitParameter(String name) {
                    return null;
                }

                public Enumeration getInitParameterNames() {
                    return new Enumeration(){

                        @Override
                        public boolean hasMoreElements() {
                            return false;
                        }

                        public Object nextElement() {
                            return null;
                        }
                    };
                }
            });
        }
        this.shiroFilter.setSecurityManager(securityManager);
        PathMatchingFilterChainResolver chainResolver = (PathMatchingFilterChainResolver)this.shiroFilter.getFilterChainResolver();
        if (chainResolver == null) {
            DefaultFilterChainManager manager = new DefaultFilterChainManager();
            chainResolver = new PathMatchingFilterChainResolver();
            chainResolver.setFilterChainManager((FilterChainManager)manager);
            this.shiroFilter.setFilterChainResolver((FilterChainResolver)chainResolver);
        }
        chainResolver.setPathMatcher((PatternMatcher)new AntPathMatcher(){

            public boolean match(String pattern, String string) {
                return super.match(pattern, string.toLowerCase());
            }
        });
        Map defaultFilters = chainResolver.getFilterChainManager().getFilters();
        for (Filter filter : defaultFilters.values()) {
            if (filter instanceof PathMatchingFilter) {
                PathMatchingFilterPatternMatcherChanger.setLowercasingPathMatcher((PathMatchingFilter)filter);
            }
            this.applyGlobalPropertiesIfNecessary(filter);
        }
        for (FilterChainDefinition filterChainDefinition : filterChainDefinitions) {
            logger.debug("adding filterChainDefinition: " + filterChainDefinition);
            chainResolver.getFilterChainManager().createChain(filterChainDefinition.getAntUrlPathExpression(), filterChainDefinition.getChainDefinition());
        }
    }

    public boolean service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, final HttpServletRequestHandler handler) throws IOException {
        final boolean[] res = new boolean[]{true};
        try {
            this.shiroFilter.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse, new FilterChain(){

                public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
                    res[0] = handler.service((HttpServletRequest)request, (HttpServletResponse)response);
                }
            });
        }
        catch (ServletException e) {
            IOException ex = new IOException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        return res[0];
    }

    private void applyLoginUrlIfNecessary(Filter filter) {
        AccessControlFilter acFilter;
        String existingLoginUrl;
        if (StringUtils.hasText((String)this.loginUrl) && filter instanceof AccessControlFilter && "/login.jsp".equals(existingLoginUrl = (acFilter = (AccessControlFilter)filter).getLoginUrl())) {
            acFilter.setLoginUrl(this.loginUrl);
        }
    }

    private void applySuccessUrlIfNecessary(Filter filter) {
        AuthenticationFilter authcFilter;
        String existingSuccessUrl;
        if (StringUtils.hasText((String)this.successUrl) && filter instanceof AuthenticationFilter && "/".equals(existingSuccessUrl = (authcFilter = (AuthenticationFilter)filter).getSuccessUrl())) {
            authcFilter.setSuccessUrl(this.successUrl);
        }
    }

    private void applyUnauthorizedUrlIfNecessary(Filter filter) {
        AuthorizationFilter authzFilter;
        String existingUnauthorizedUrl;
        if (StringUtils.hasText((String)this.unauthorizedUrl) && filter instanceof AuthorizationFilter && (existingUnauthorizedUrl = (authzFilter = (AuthorizationFilter)filter).getUnauthorizedUrl()) == null) {
            authzFilter.setUnauthorizedUrl(this.unauthorizedUrl);
        }
    }

    private void applyGlobalPropertiesIfNecessary(Filter filter) {
        this.applyLoginUrlIfNecessary(filter);
        this.applySuccessUrlIfNecessary(filter);
        this.applyUnauthorizedUrlIfNecessary(filter);
    }
}

