/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.shiro.extension.authz.aop;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresGuest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.apache.shiro.authz.annotation.RequiresUser;
import org.apache.shiro.authz.aop.AuthorizingAnnotationHandler;
import org.tynamo.shiro.extension.authz.annotations.utils.casters.method.HandlerCreateVisitor;
import org.tynamo.shiro.extension.authz.annotations.utils.casters.method.MethodAnnotationCaster;
import org.tynamo.shiro.extension.authz.aop.DefaultSecurityInterceptor;
import org.tynamo.shiro.extension.authz.aop.SecurityInterceptor;

public class AopHelper {
    private static final Collection<Class<? extends Annotation>> autorizationAnnotationClasses = new ArrayList<Class<? extends Annotation>>(5);

    public static AuthorizingAnnotationHandler createHandler(Annotation annotation) {
        HandlerCreateVisitor visitor = new HandlerCreateVisitor();
        MethodAnnotationCaster.getInstance().accept(visitor, annotation);
        return visitor.getHandler();
    }

    public static List<SecurityInterceptor> createSecurityInterceptors(Method method, Class<?> clazz) {
        ArrayList<SecurityInterceptor> result = new ArrayList<SecurityInterceptor>();
        if (AopHelper.isInterceptOnClassAnnotation(method.getModifiers())) {
            for (Class<? extends Annotation> ac : AopHelper.getAutorizationAnnotationClasses()) {
                Annotation annotationOnClass = clazz.getAnnotation(ac);
                if (annotationOnClass == null) continue;
                result.add(new DefaultSecurityInterceptor(annotationOnClass));
            }
        }
        for (Class<? extends Annotation> ac : AopHelper.getAutorizationAnnotationClasses()) {
            Annotation annotation = method.getAnnotation(ac);
            if (annotation == null) continue;
            result.add(new DefaultSecurityInterceptor(annotation));
        }
        return result;
    }

    public static List<SecurityInterceptor> createSecurityInterceptorsSeeingInterfaces(Method method, Class<?> targetClass) {
        ArrayList<SecurityInterceptor> interceptors = new ArrayList<SecurityInterceptor>();
        method = AopHelper.findTargetMethod(method, targetClass);
        interceptors.addAll(AopHelper.createSecurityInterceptors(method, targetClass));
        HashSet allInterfaces = new HashSet();
        AopHelper.getAllInterfaces(allInterfaces, targetClass);
        for (Class clazz : allInterfaces) {
            try {
                Method candidate = clazz.getMethod(method.getName(), method.getParameterTypes());
                interceptors.addAll(AopHelper.createSecurityInterceptors(candidate, clazz));
            }
            catch (SecurityException e) {
                new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {}
        }
        return interceptors;
    }

    public static Method findTargetMethod(Method method, Class<?> targetClass) {
        try {
            method = targetClass.getDeclaredMethod(method.getName(), method.getParameterTypes());
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return method;
    }

    private static void getAllInterfaces(Set<Class<?>> searchInterfaces, Class<?> clazz) {
        while (clazz != null) {
            searchInterfaces.addAll(Arrays.asList(clazz.getInterfaces()));
            for (Class<?> intf : clazz.getInterfaces()) {
                AopHelper.getAllInterfaces(searchInterfaces, intf);
            }
            clazz = clazz.getSuperclass();
        }
    }

    public static boolean isInterceptOnClassAnnotation(int modifiers) {
        return Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers);
    }

    public static Collection<Class<? extends Annotation>> getAutorizationAnnotationClasses() {
        return autorizationAnnotationClasses;
    }

    static {
        autorizationAnnotationClasses.add(RequiresPermissions.class);
        autorizationAnnotationClasses.add(RequiresRoles.class);
        autorizationAnnotationClasses.add(RequiresUser.class);
        autorizationAnnotationClasses.add(RequiresGuest.class);
        autorizationAnnotationClasses.add(RequiresAuthentication.class);
    }
}

