/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.security.services.impl;

import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.web.util.WebUtils;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.services.LocalizationSetter;
import org.tynamo.security.services.PageService;

public class PageServiceImpl
implements PageService {
    private String loginPage;
    private String successPage;
    private String unauthorizedPage;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final LocalizationSetter localizationSetter;

    public PageServiceImpl(@Inject @Symbol(value="security.successurl") String successUrl, @Inject @Symbol(value="security.loginurl") String loginUrl, @Inject @Symbol(value="security.unauthorizedurl") String unauthorizedUrl, HttpServletRequest request, HttpServletResponse response, LocalizationSetter localizationSetter) {
        this.request = request;
        this.response = response;
        this.localizationSetter = localizationSetter;
        this.loginPage = PageServiceImpl.urlToPage(loginUrl);
        this.successPage = PageServiceImpl.urlToPage(successUrl);
        this.unauthorizedPage = PageServiceImpl.urlToPage(unauthorizedUrl);
    }

    @Override
    public String getLoginPage() {
        return this.loginPage;
    }

    @Override
    public String getSuccessPage() {
        return this.successPage;
    }

    @Override
    public String getUnauthorizedPage() {
        return this.unauthorizedPage;
    }

    private static String urlToPage(String url) {
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        return url;
    }

    @Override
    public String getLocalelessPathWithinApplication() {
        String path = WebUtils.getPathWithinApplication((HttpServletRequest)this.request);
        String locale = this.getLocaleFromPath(path);
        return locale == null ? path : path.substring(locale.length() + 1);
    }

    @Override
    public String getLocaleFromPath(String path) {
        String[] split = path.substring(1).split("/");
        if (split.length > 1 && !"".equals(split[0])) {
            String possibleLocaleName = split[0];
            return this.localizationSetter.isSupportedLocaleName(possibleLocaleName) ? possibleLocaleName : null;
        }
        return null;
    }

    private Cookie createSavedRequestCookie() {
        String requestUri = this.request.getRequestURI();
        if (this.request.getQueryString() != null) {
            requestUri = requestUri + "?" + this.request.getQueryString();
        }
        Cookie cookie = new Cookie("shiroSavedRequest", requestUri);
        String contextPath = this.request.getContextPath();
        if ("".equals(contextPath)) {
            contextPath = "/";
        }
        cookie.setPath(contextPath);
        return cookie;
    }

    @Override
    public void saveRequest() {
        this.response.addCookie(this.createSavedRequestCookie());
    }

    @Override
    public void redirectToSavedRequest(String fallbackUrl) throws IOException {
        Cookie[] cookies = this.request.getCookies();
        String requestUri = null;
        for (Cookie cookie : cookies) {
            if (!"shiroSavedRequest".equals(cookie.getName())) continue;
            requestUri = cookie.getValue();
            Cookie deleteCookie = this.createSavedRequestCookie();
            deleteCookie.setMaxAge(0);
            this.response.addCookie(deleteCookie);
            WebUtils.issueRedirect((ServletRequest)this.request, (ServletResponse)this.response, (String)requestUri);
            break;
        }
    }
}

