/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.security.services.impl;

import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.tynamo.security.services.SecurityService;

public class SecurityServiceImpl
implements SecurityService {
    private static final String ROLE_NAMES_DELIMETER = ",";
    private static final String PERMISSIONS_DELIMETER = "\\|";
    private static final String PERMISSIONS_OR_ROLES_DELIMETER = "(,|\\|)";

    @Override
    public Subject getSubject() {
        return SecurityUtils.getSubject();
    }

    @Override
    public boolean isAuthenticated() {
        Subject subject = this.getSubject();
        return subject != null && subject.isAuthenticated();
    }

    @Override
    public boolean isNotAuthenticated() {
        Subject subject = this.getSubject();
        return subject == null || !subject.isAuthenticated();
    }

    @Override
    public boolean isUser() {
        Subject subject = this.getSubject();
        return subject != null && subject.getPrincipal() != null;
    }

    @Override
    public boolean isGuest() {
        Subject subject = this.getSubject();
        return subject == null || subject.getPrincipal() == null;
    }

    @Override
    public boolean hasAnyRoles(String roles) {
        boolean hasAnyRole = false;
        Subject subject = this.getSubject();
        if (subject != null) {
            for (String role : roles.split(PERMISSIONS_OR_ROLES_DELIMETER)) {
                if (!subject.hasRole(role.trim())) continue;
                hasAnyRole = true;
                break;
            }
        }
        return hasAnyRole;
    }

    @Override
    public boolean hasAllRoles(String roles) {
        boolean hasAllRole = false;
        Subject subject = this.getSubject();
        if (subject != null) {
            hasAllRole = true;
            for (String role : roles.split(PERMISSIONS_OR_ROLES_DELIMETER)) {
                if (subject.hasRole(role.trim())) continue;
                hasAllRole = false;
                break;
            }
        }
        return hasAllRole;
    }

    @Override
    public boolean hasAllPermissions(String permissions) {
        boolean hasAllPermissions = false;
        Subject subject = this.getSubject();
        if (subject != null) {
            return subject.isPermittedAll(permissions.split(PERMISSIONS_DELIMETER));
        }
        return hasAllPermissions;
    }

    @Override
    public boolean hasAnyPermissions(String permissions) {
        boolean hasAnyPermissions = false;
        Subject subject = this.getSubject();
        if (subject != null) {
            for (String role : permissions.split(PERMISSIONS_DELIMETER)) {
                if (!subject.isPermitted(role.trim())) continue;
                hasAnyPermissions = true;
                break;
            }
        }
        return hasAnyPermissions;
    }

    @Override
    public boolean hasPermission(String permission) {
        Subject subject = this.getSubject();
        return subject != null && subject.isPermitted(permission);
    }

    @Override
    public boolean hasRole(String role) {
        Subject subject = this.getSubject();
        return subject != null && subject.hasRole(role);
    }

    @Override
    public boolean isLacksPermission(String permission) {
        return !this.hasPermission(permission);
    }

    @Override
    public boolean isLacksRole(String role) {
        return !this.hasRole(role);
    }
}

