/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.security.services;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.ShiroException;
import org.apache.shiro.util.ClassUtils;
import org.apache.shiro.util.StringUtils;
import org.apache.shiro.util.ThreadContext;
import org.apache.shiro.web.mgt.WebSecurityManager;
import org.apache.shiro.web.util.WebUtils;
import org.apache.tapestry5.internal.services.PageResponseRenderer;
import org.apache.tapestry5.internal.services.RequestPageCache;
import org.apache.tapestry5.internal.structure.Page;
import org.apache.tapestry5.ioc.Configuration;
import org.apache.tapestry5.ioc.Invocation;
import org.apache.tapestry5.ioc.MappedConfiguration;
import org.apache.tapestry5.ioc.MethodAdvice;
import org.apache.tapestry5.ioc.MethodAdviceReceiver;
import org.apache.tapestry5.ioc.OrderedConfiguration;
import org.apache.tapestry5.ioc.ServiceBinder;
import org.apache.tapestry5.ioc.annotations.InjectService;
import org.apache.tapestry5.ioc.annotations.Local;
import org.apache.tapestry5.ioc.annotations.Match;
import org.apache.tapestry5.ioc.annotations.Order;
import org.apache.tapestry5.ioc.annotations.SubModule;
import org.apache.tapestry5.services.ApplicationInitializer;
import org.apache.tapestry5.services.ApplicationInitializerFilter;
import org.apache.tapestry5.services.ComponentClassResolver;
import org.apache.tapestry5.services.ComponentClassTransformWorker;
import org.apache.tapestry5.services.ComponentRequestFilter;
import org.apache.tapestry5.services.Context;
import org.apache.tapestry5.services.Cookies;
import org.apache.tapestry5.services.HttpServletRequestFilter;
import org.apache.tapestry5.services.LibraryMapping;
import org.apache.tapestry5.services.Response;
import org.tynamo.common.ModuleProperties;
import org.tynamo.exceptionpage.ExceptionHandlerAssistant;
import org.tynamo.exceptionpage.services.ExceptionPageModule;
import org.tynamo.security.SecurityComponentRequestFilter;
import org.tynamo.security.ShiroAnnotationWorker;
import org.tynamo.security.services.ClassInterceptorsCache;
import org.tynamo.security.services.PageService;
import org.tynamo.security.services.SecurityFilterChainFactory;
import org.tynamo.security.services.SecurityService;
import org.tynamo.security.services.TapestryRealmSecurityManager;
import org.tynamo.security.services.impl.ClassInterceptorsCacheImpl;
import org.tynamo.security.services.impl.PageServiceImpl;
import org.tynamo.security.services.impl.SecurityConfiguration;
import org.tynamo.security.services.impl.SecurityFilterChainFactoryImpl;
import org.tynamo.security.services.impl.SecurityServiceImpl;
import org.tynamo.shiro.extension.authz.aop.AopHelper;
import org.tynamo.shiro.extension.authz.aop.DefaultSecurityInterceptor;
import org.tynamo.shiro.extension.authz.aop.SecurityInterceptor;

@SubModule(value={ExceptionPageModule.class})
public class SecurityModule {
    private static final String EXCEPTION_HANDLE_METHOD_NAME = "handleRequestException";
    private static final String PATH_PREFIX = "security";
    private static final String version = ModuleProperties.getVersion(SecurityModule.class);

    public static void bind(ServiceBinder binder) {
        binder.bind(WebSecurityManager.class, TapestryRealmSecurityManager.class);
        binder.bind(HttpServletRequestFilter.class, SecurityConfiguration.class).withId("SecurityConfiguration");
        binder.bind(ClassInterceptorsCache.class, ClassInterceptorsCacheImpl.class);
        binder.bind(SecurityService.class, SecurityServiceImpl.class);
        binder.bind(SecurityFilterChainFactory.class, SecurityFilterChainFactoryImpl.class);
        binder.bind(ComponentRequestFilter.class, SecurityComponentRequestFilter.class);
        binder.bind(PageService.class, PageServiceImpl.class);
    }

    public static void contributeFactoryDefaults(MappedConfiguration<String, String> configuration) {
        configuration.add((Object)"security.loginurl", (Object)"/security/login");
        configuration.add((Object)"security.successurl", (Object)"/index");
        configuration.add((Object)"security.unauthorizedurl", (Object)"/security/unauthorized");
        configuration.add((Object)"security.redirecttosavedurl", (Object)"true");
    }

    public void contributeApplicationInitializer(OrderedConfiguration<ApplicationInitializerFilter> configuration, final ComponentClassResolver componentClassResolver, final ClassInterceptorsCache classInterceptorsCache) {
        configuration.add("SecurityApplicationInitializerFilter", (Object)new ApplicationInitializerFilter(){

            public void initializeApplication(Context context, ApplicationInitializer initializer) {
                initializer.initializeApplication(context);
                for (String name : componentClassResolver.getPageNames()) {
                    String className = componentClassResolver.resolvePageNameToClassName(name);
                    for (Class clazz = ClassUtils.forName((String)className); clazz != null; clazz = clazz.getSuperclass()) {
                        for (Class<? extends Annotation> annotationClass : AopHelper.getAutorizationAnnotationClasses()) {
                            Annotation classAnnotation = clazz.getAnnotation(annotationClass);
                            if (classAnnotation == null) continue;
                            classInterceptorsCache.add(className, new DefaultSecurityInterceptor(classAnnotation));
                        }
                    }
                }
            }
        }, new String[0]);
    }

    public static void contributeComponentRequestHandler(OrderedConfiguration<ComponentRequestFilter> configuration, @Local ComponentRequestFilter filter) {
        configuration.add("SecurityFilter", (Object)filter, new String[]{"before:*"});
    }

    public static void contributeComponentClassTransformWorker(OrderedConfiguration<ComponentClassTransformWorker> configuration) {
        configuration.addInstance(ShiroAnnotationWorker.class.getSimpleName(), ShiroAnnotationWorker.class, new String[0]);
    }

    public static void contributeComponentClassResolver(Configuration<LibraryMapping> configuration) {
        configuration.add((Object)new LibraryMapping(PATH_PREFIX, "org.tynamo.security"));
    }

    public static void contributeClasspathAssetAliasManager(MappedConfiguration<String, String> configuration) {
        configuration.add((Object)("security-" + version), (Object)"org/tynamo/security");
    }

    @Match(value={"*"})
    @Order(value={"before:*"})
    public static void adviseSecurityAssert(MethodAdviceReceiver receiver) {
        Class serviceInterface = receiver.getInterface();
        for (Method method : serviceInterface.getMethods()) {
            List<SecurityInterceptor> interceptors = AopHelper.createSecurityInterceptorsSeeingInterfaces(method, serviceInterface);
            for (final SecurityInterceptor interceptor : interceptors) {
                MethodAdvice advice = new MethodAdvice(){

                    public void advise(Invocation invocation) {
                        if (ThreadContext.getSubject() != null) {
                            interceptor.intercept();
                        }
                        invocation.proceed();
                    }
                };
                receiver.adviseMethod(method, advice);
            }
        }
    }

    public void contributeExceptionHandler(MappedConfiguration<Class, Object> configuration, final PageResponseRenderer renderer, final RequestPageCache pageCache, final SecurityService securityService, final PageService pageService, final HttpServletRequest servletRequest, final Response response, final Cookies cookies) {
        ExceptionHandlerAssistant assistant = new ExceptionHandlerAssistant(){

            public Object handleRequestException(Throwable exception, List<Object> exceptionContext) throws IOException {
                if (securityService.isAuthenticated()) {
                    String unauthorizedPage = pageService.getUnauthorizedPage();
                    response.setStatus(401);
                    if (!StringUtils.hasText((String)unauthorizedPage)) {
                        return null;
                    }
                    Page page = pageCache.get(unauthorizedPage);
                    renderer.renderPageResponse(page);
                    return null;
                }
                String contextPath = servletRequest.getContextPath();
                if ("".equals(contextPath)) {
                    contextPath = "/";
                }
                cookies.writeCookieValue("shiroSavedRequest", WebUtils.getPathWithinApplication((HttpServletRequest)servletRequest), contextPath);
                return pageService.getLoginPage();
            }
        };
        configuration.add(ShiroException.class, (Object)assistant);
    }

    public static void contributeHttpServletRequestHandler(OrderedConfiguration<HttpServletRequestFilter> configuration, @InjectService(value="SecurityConfiguration") HttpServletRequestFilter securityConfiguration) {
        configuration.add("SecurityConfiguration", (Object)securityConfiguration, new String[]{"after:StoreIntoGlobals"});
    }
}

