/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.security.shiro.authc;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.util.WebUtils;
import org.tynamo.security.services.PageService;
import org.tynamo.security.shiro.AccessControlFilter;

public abstract class AuthenticationFilter
extends AccessControlFilter {
    public AuthenticationFilter(PageService pageService) {
        super(pageService);
    }

    @Override
    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        Subject subject = this.getSubject(request, response);
        return subject.isAuthenticated();
    }

    protected void issueSuccessRedirect(ServletRequest request, ServletResponse response) throws Exception {
        String contextPath = WebUtils.toHttp((ServletRequest)request).getContextPath();
        if ("/".equals(contextPath)) {
            contextPath = "";
        }
        String requestUri = contextPath + this.getSuccessUrl();
        if (this.isRedirectToSavedUrl()) {
            this.getPageService().redirectToSavedRequest(requestUri);
            return;
        }
        WebUtils.issueRedirect((ServletRequest)request, (ServletResponse)response, (String)requestUri);
    }
}

