/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.security.services;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.shiro.ShiroException;
import org.apache.shiro.mgt.RememberMeManager;
import org.apache.shiro.mgt.SubjectFactory;
import org.apache.shiro.util.ClassUtils;
import org.apache.shiro.util.ThreadContext;
import org.apache.shiro.web.mgt.CookieRememberMeManager;
import org.apache.shiro.web.mgt.DefaultWebSubjectFactory;
import org.apache.shiro.web.mgt.WebSecurityManager;
import org.apache.tapestry5.ioc.Configuration;
import org.apache.tapestry5.ioc.MappedConfiguration;
import org.apache.tapestry5.ioc.MethodAdviceReceiver;
import org.apache.tapestry5.ioc.OrderedConfiguration;
import org.apache.tapestry5.ioc.ServiceBinder;
import org.apache.tapestry5.ioc.annotations.Autobuild;
import org.apache.tapestry5.ioc.annotations.Contribute;
import org.apache.tapestry5.ioc.annotations.InjectService;
import org.apache.tapestry5.ioc.annotations.Local;
import org.apache.tapestry5.ioc.annotations.Marker;
import org.apache.tapestry5.ioc.annotations.Match;
import org.apache.tapestry5.ioc.annotations.Order;
import org.apache.tapestry5.ioc.annotations.SubModule;
import org.apache.tapestry5.plastic.MethodAdvice;
import org.apache.tapestry5.plastic.MethodInvocation;
import org.apache.tapestry5.services.ApplicationInitializer;
import org.apache.tapestry5.services.ApplicationInitializerFilter;
import org.apache.tapestry5.services.ComponentClassResolver;
import org.apache.tapestry5.services.ComponentRequestFilter;
import org.apache.tapestry5.services.Context;
import org.apache.tapestry5.services.Core;
import org.apache.tapestry5.services.Environment;
import org.apache.tapestry5.services.HttpServletRequestFilter;
import org.apache.tapestry5.services.LibraryMapping;
import org.apache.tapestry5.services.transform.ComponentClassTransformWorker2;
import org.tynamo.common.ModuleProperties;
import org.tynamo.exceptionpage.services.ExceptionPageModule;
import org.tynamo.security.Security;
import org.tynamo.security.SecurityComponentRequestFilter;
import org.tynamo.security.ShiroAnnotationWorker;
import org.tynamo.security.internal.ModularRealmAuthenticator;
import org.tynamo.security.internal.SecurityExceptionHandlerAssistant;
import org.tynamo.security.internal.services.LoginContextService;
import org.tynamo.security.internal.services.impl.LoginContextServiceImpl;
import org.tynamo.security.services.ClassInterceptorsCache;
import org.tynamo.security.services.PageService;
import org.tynamo.security.services.SecurityFilterChainFactory;
import org.tynamo.security.services.SecurityService;
import org.tynamo.security.services.TapestryRealmSecurityManager;
import org.tynamo.security.services.impl.ClassInterceptorsCacheImpl;
import org.tynamo.security.services.impl.PageServiceImpl;
import org.tynamo.security.services.impl.SecurityConfiguration;
import org.tynamo.security.services.impl.SecurityFilterChainFactoryImpl;
import org.tynamo.security.services.impl.SecurityServiceImpl;
import org.tynamo.shiro.extension.authz.aop.AopHelper;
import org.tynamo.shiro.extension.authz.aop.DefaultSecurityInterceptor;
import org.tynamo.shiro.extension.authz.aop.SecurityInterceptor;

@SubModule(value={ExceptionPageModule.class})
@Marker(value={Security.class})
public class SecurityModule {
    private static final String EXCEPTION_HANDLE_METHOD_NAME = "handleRequestException";
    private static final String PATH_PREFIX = "security";
    private static final String version = ModuleProperties.getVersion(SecurityModule.class);

    public static void bind(ServiceBinder binder) {
        binder.bind(WebSecurityManager.class, TapestryRealmSecurityManager.class);
        binder.bind(ModularRealmAuthenticator.class);
        binder.bind(SubjectFactory.class, DefaultWebSubjectFactory.class);
        binder.bind(RememberMeManager.class, CookieRememberMeManager.class);
        binder.bind(HttpServletRequestFilter.class, SecurityConfiguration.class).withId("SecurityConfiguration");
        binder.bind(ClassInterceptorsCache.class, ClassInterceptorsCacheImpl.class);
        binder.bind(SecurityService.class, SecurityServiceImpl.class);
        binder.bind(SecurityFilterChainFactory.class, SecurityFilterChainFactoryImpl.class);
        binder.bind(ComponentRequestFilter.class, SecurityComponentRequestFilter.class);
        binder.bind(LoginContextService.class, LoginContextServiceImpl.class);
        binder.bind(PageService.class, PageServiceImpl.class);
    }

    public static void contributeFactoryDefaults(MappedConfiguration<String, String> configuration) {
        configuration.add((Object)"security.loginurl", (Object)"/security/login");
        configuration.add((Object)"security.successurl", (Object)"/index");
        configuration.add((Object)"security.unauthorizedurl", (Object)"/security/unauthorized");
        configuration.add((Object)"security.redirecttosavedurl", (Object)"true");
    }

    public void contributeApplicationInitializer(OrderedConfiguration<ApplicationInitializerFilter> configuration, final ComponentClassResolver componentClassResolver, final ClassInterceptorsCache classInterceptorsCache) {
        configuration.add("SecurityApplicationInitializerFilter", (Object)new ApplicationInitializerFilter(){

            public void initializeApplication(Context context, ApplicationInitializer initializer) {
                initializer.initializeApplication(context);
                for (String name : componentClassResolver.getPageNames()) {
                    String className = componentClassResolver.resolvePageNameToClassName(name);
                    for (Class clazz = ClassUtils.forName((String)className); clazz != null; clazz = clazz.getSuperclass()) {
                        for (Class<? extends Annotation> annotationClass : AopHelper.getAutorizationAnnotationClasses()) {
                            Annotation classAnnotation = clazz.getAnnotation(annotationClass);
                            if (classAnnotation == null) continue;
                            classInterceptorsCache.add(className, new DefaultSecurityInterceptor(classAnnotation));
                        }
                    }
                }
            }
        }, new String[0]);
    }

    public static void contributeComponentRequestHandler(OrderedConfiguration<ComponentRequestFilter> configuration, @Local ComponentRequestFilter filter) {
        configuration.add("SecurityFilter", (Object)filter, new String[]{"before:*"});
    }

    @Contribute(value=ComponentClassTransformWorker2.class)
    public static void addTransformWorkers(OrderedConfiguration<ComponentClassTransformWorker2> configuration) {
        configuration.addInstance(ShiroAnnotationWorker.class.getSimpleName(), ShiroAnnotationWorker.class, new String[0]);
    }

    public static void contributeComponentClassResolver(Configuration<LibraryMapping> configuration) {
        configuration.add((Object)new LibraryMapping(PATH_PREFIX, "org.tynamo.security"));
    }

    public static void contributeClasspathAssetAliasManager(MappedConfiguration<String, String> configuration) {
        configuration.add((Object)("security-" + version), (Object)"org/tynamo/security");
    }

    @Match(value={"*"})
    @Order(value={"before:*"})
    public static void adviseSecurityAssert(MethodAdviceReceiver receiver, final @Core Environment environment) {
        Class serviceInterface = receiver.getInterface();
        for (Method method : serviceInterface.getMethods()) {
            List<SecurityInterceptor> interceptors = AopHelper.createSecurityInterceptorsSeeingInterfaces(method, serviceInterface);
            for (final SecurityInterceptor interceptor : interceptors) {
                MethodAdvice advice = new MethodAdvice(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void advise(MethodInvocation invocation) {
                        if (ThreadContext.getSubject() != null) {
                            environment.push(MethodInvocation.class, (Object)invocation);
                            try {
                                interceptor.intercept();
                            }
                            finally {
                                environment.pop(MethodInvocation.class);
                            }
                        }
                        invocation.proceed();
                    }
                };
                receiver.adviseMethod(method, advice);
            }
        }
    }

    public void contributeExceptionHandler(MappedConfiguration<Class, Object> configuration, @Autobuild SecurityExceptionHandlerAssistant assistant) {
        configuration.add(ShiroException.class, (Object)assistant);
    }

    public static void contributeHttpServletRequestHandler(OrderedConfiguration<HttpServletRequestFilter> configuration, @InjectService(value="SecurityConfiguration") HttpServletRequestFilter securityConfiguration) {
        configuration.add("SecurityConfiguration", (Object)securityConfiguration, new String[]{"after:StoreIntoGlobals"});
    }
}

