/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.security.services.impl;

import org.apache.shiro.util.AntPathMatcher;
import org.apache.shiro.util.PatternMatcher;
import org.apache.shiro.util.RegExPatternMatcher;
import org.apache.tapestry5.ioc.annotations.EagerLoad;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.services.PipelineBuilder;
import org.slf4j.Logger;
import org.tynamo.security.internal.services.LoginContextService;
import org.tynamo.security.services.SecurityFilterChainFactory;
import org.tynamo.security.services.impl.SecurityFilterChain;
import org.tynamo.security.shiro.AccessControlFilter;
import org.tynamo.security.shiro.authc.AnonymousFilter;
import org.tynamo.security.shiro.authc.BasicHttpAuthenticationFilter;
import org.tynamo.security.shiro.authc.FormAuthenticationFilter;
import org.tynamo.security.shiro.authc.UserFilter;
import org.tynamo.security.shiro.authz.NotFoundFilter;
import org.tynamo.security.shiro.authz.PermissionsAuthorizationFilter;
import org.tynamo.security.shiro.authz.PortFilter;
import org.tynamo.security.shiro.authz.RolesAuthorizationFilter;
import org.tynamo.security.shiro.authz.SslFilter;

@EagerLoad
public class SecurityFilterChainFactoryImpl
implements SecurityFilterChainFactory {
    private final Logger logger;
    private final PipelineBuilder builder;
    private final LoginContextService loginContextService;
    private final AntPathMatcher antPathMatcher = new AntPathMatcher();
    private final RegExPatternMatcher regExPatternMatcher = new RegExPatternMatcher();

    public SecurityFilterChainFactoryImpl(Logger logger, PipelineBuilder builder, LoginContextService loginContextService, @Inject @Symbol(value="security.successurl") String successUrl, @Inject @Symbol(value="security.loginurl") String loginUrl, @Inject @Symbol(value="security.unauthorizedurl") String unauthorizedUrl, @Inject @Symbol(value="security.redirecttosavedurl") boolean redirectToSavedUrl) {
        this.builder = builder;
        this.logger = logger;
        this.loginContextService = loginContextService;
        AccessControlFilter.LOGIN_URL = loginUrl;
        AccessControlFilter.SUCCESS_URL = successUrl;
        AccessControlFilter.UNAUTHORIZED_URL = unauthorizedUrl;
    }

    @Override
    public SecurityFilterChain.Builder createChain(String path) {
        return new SecurityFilterChain.Builder(this.logger, this.builder, path, (PatternMatcher)this.antPathMatcher);
    }

    @Override
    public SecurityFilterChain.Builder createChain(String pattern, PatternMatcher patternMatcher) {
        return new SecurityFilterChain.Builder(this.logger, this.builder, pattern, patternMatcher);
    }

    @Override
    public SecurityFilterChain.Builder createChainWithAntPath(String path) {
        return new SecurityFilterChain.Builder(this.logger, this.builder, path, (PatternMatcher)this.antPathMatcher);
    }

    @Override
    public SecurityFilterChain.Builder createChainWithRegEx(String pattern) {
        return new SecurityFilterChain.Builder(this.logger, this.builder, pattern, (PatternMatcher)this.regExPatternMatcher);
    }

    @Override
    public AnonymousFilter anon() {
        String name = "anon";
        AnonymousFilter filter = new AnonymousFilter(this.loginContextService);
        filter.setName(name);
        return filter;
    }

    @Override
    public NotFoundFilter notfound() {
        return new NotFoundFilter();
    }

    @Override
    public UserFilter user() {
        String name = "user";
        UserFilter filter = new UserFilter(this.loginContextService);
        filter.setName(name);
        return filter;
    }

    @Override
    public FormAuthenticationFilter authc() {
        String name = "authc";
        FormAuthenticationFilter filter = new FormAuthenticationFilter(this.loginContextService);
        filter.setName(name);
        return filter;
    }

    @Override
    public BasicHttpAuthenticationFilter basic() {
        String name = "authcBasic";
        BasicHttpAuthenticationFilter filter = new BasicHttpAuthenticationFilter(this.loginContextService);
        filter.setName(name);
        return filter;
    }

    @Override
    public RolesAuthorizationFilter roles() {
        String name = "roles";
        RolesAuthorizationFilter filter = new RolesAuthorizationFilter(this.loginContextService);
        filter.setName(name);
        return filter;
    }

    @Override
    public PermissionsAuthorizationFilter perms() {
        String name = "perms";
        PermissionsAuthorizationFilter filter = new PermissionsAuthorizationFilter(this.loginContextService);
        filter.setName(name);
        return filter;
    }

    @Override
    public SslFilter ssl() {
        SslFilter filter = new SslFilter(this.loginContextService);
        filter.setName("ssl");
        return filter;
    }

    @Override
    public PortFilter port() {
        PortFilter filter = new PortFilter(this.loginContextService);
        filter.setName("port");
        return filter;
    }
}

