/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.security.services.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.Callable;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.util.ThreadContext;
import org.apache.shiro.web.mgt.WebSecurityManager;
import org.apache.shiro.web.servlet.ShiroHttpServletRequest;
import org.apache.shiro.web.subject.WebSubject;
import org.apache.tapestry5.services.ApplicationGlobals;
import org.apache.tapestry5.services.HttpServletRequestFilter;
import org.apache.tapestry5.services.HttpServletRequestHandler;
import org.tynamo.security.internal.services.LoginContextService;
import org.tynamo.security.services.impl.SecurityFilterChain;

public class SecurityConfiguration
implements HttpServletRequestFilter {
    private final SecurityManager securityManager;
    private final ServletContext servletContext;
    private final LoginContextService loginContextService;
    private final Collection<SecurityFilterChain> chains;

    public SecurityConfiguration(ApplicationGlobals applicationGlobals, WebSecurityManager securityManager, LoginContextService loginContextService, Collection<SecurityFilterChain> chains) {
        this.securityManager = securityManager;
        this.loginContextService = loginContextService;
        this.servletContext = applicationGlobals.getServletContext();
        this.chains = chains;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean service(HttpServletRequest originalRequest, HttpServletResponse response, final HttpServletRequestHandler handler) throws IOException {
        if (originalRequest instanceof ShiroHttpServletRequest) {
            return handler.service(originalRequest, response);
        }
        ShiroHttpServletRequest request = new ShiroHttpServletRequest(originalRequest, this.servletContext, true);
        String requestURI = this.loginContextService.getLocalelessPathWithinApplication();
        final SecurityFilterChain chain = this.getMatchingChain(requestURI);
        ThreadContext.bind((SecurityManager)this.securityManager);
        WebSubject subject = new WebSubject.Builder(this.securityManager, (ServletRequest)originalRequest, (ServletResponse)response).buildWebSubject();
        try {
            boolean bl = (Boolean)subject.execute((Callable)new Callable<Boolean>((HttpServletRequest)request, response){
                final /* synthetic */ HttpServletRequest val$request;
                final /* synthetic */ HttpServletResponse val$response;
                {
                    this.val$request = httpServletRequest;
                    this.val$response = httpServletResponse;
                }

                @Override
                public Boolean call() throws Exception {
                    if (chain == null) {
                        return handler.service(this.val$request, this.val$response);
                    }
                    boolean handled = chain.getHandler().service(this.val$request, this.val$response);
                    return handled || handler.service(this.val$request, this.val$response);
                }
            });
            return bl;
        }
        finally {
            ThreadContext.remove();
        }
    }

    private SecurityFilterChain getMatchingChain(String requestURI) {
        for (SecurityFilterChain chain : this.chains) {
            if (!chain.matches(requestURI)) continue;
            return chain;
        }
        return null;
    }
}

