/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.security.shiro.authz;

import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.config.ConfigurationException;
import org.apache.shiro.util.StringUtils;
import org.apache.shiro.web.util.WebUtils;
import org.tynamo.security.internal.services.LoginContextService;
import org.tynamo.security.shiro.authz.AuthorizationFilter;

public class PortFilter
extends AuthorizationFilter {
    public static final int DEFAULT_HTTP_PORT = 80;
    public static final String HTTP_SCHEME = "http";
    private int port = 80;

    public PortFilter(LoginContextService loginContextService) {
        super(loginContextService);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    protected int toPort(Object mappedValue) {
        Object[] ports = (String[])mappedValue;
        if (ports == null || ports.length == 0) {
            return this.getPort();
        }
        if (ports.length > 1) {
            throw new ConfigurationException("PortFilter can only be configured with a single port.  You have configured " + ports.length + ": " + StringUtils.toString((Object[])ports));
        }
        return Integer.parseInt(ports[0]);
    }

    @Override
    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) throws Exception {
        int requestPort;
        int requiredPort = this.toPort(mappedValue);
        return requiredPort == (requestPort = request.getServerPort());
    }

    protected String getScheme(String requestScheme, int port) {
        if (port == 80) {
            return HTTP_SCHEME;
        }
        if (port == 443) {
            return "https";
        }
        return requestScheme;
    }

    @Override
    protected boolean onAccessDenied(ServletRequest request, ServletResponse response, Object mappedValue) throws IOException {
        int port = this.toPort(mappedValue);
        String scheme = this.getScheme(request.getScheme(), port);
        StringBuilder sb = new StringBuilder();
        sb.append(scheme).append("://");
        sb.append(request.getServerName());
        if (port != 80 && port != 443) {
            sb.append(":");
            sb.append(port);
        }
        if (request instanceof HttpServletRequest) {
            sb.append(WebUtils.toHttp((ServletRequest)request).getRequestURI());
            String query = WebUtils.toHttp((ServletRequest)request).getQueryString();
            if (query != null) {
                sb.append("?").append(query);
            }
        }
        WebUtils.issueRedirect((ServletRequest)request, (ServletResponse)response, (String)sb.toString());
        return false;
    }
}

