/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.security.services.impl;

import java.io.IOException;
import java.util.Collection;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.ThreadContext;
import org.apache.shiro.web.mgt.WebSecurityManager;
import org.apache.shiro.web.servlet.ShiroHttpServletRequest;
import org.apache.shiro.web.subject.WebSubject;
import org.apache.tapestry5.services.ApplicationGlobals;
import org.apache.tapestry5.services.HttpServletRequestFilter;
import org.apache.tapestry5.services.HttpServletRequestHandler;
import org.apache.tapestry5.services.RequestGlobals;
import org.tynamo.security.internal.services.LoginContextService;
import org.tynamo.security.services.impl.SecurityFilterChain;

public class SecurityConfiguration
implements HttpServletRequestFilter {
    private final SecurityManager securityManager;
    private final ServletContext servletContext;
    private final LoginContextService loginContextService;
    private final Collection<SecurityFilterChain> chains;
    private final RequestGlobals requestGlobals;

    public SecurityConfiguration(ApplicationGlobals applicationGlobals, RequestGlobals requestGlobals, WebSecurityManager securityManager, LoginContextService loginContextService, Collection<SecurityFilterChain> chains) {
        this.securityManager = securityManager;
        this.loginContextService = loginContextService;
        this.servletContext = applicationGlobals.getServletContext();
        this.requestGlobals = requestGlobals;
        this.chains = chains;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean service(HttpServletRequest originalRequest, HttpServletResponse response, HttpServletRequestHandler handler) throws IOException {
        if (originalRequest instanceof ShiroHttpServletRequest) {
            return handler.service(originalRequest, response);
        }
        ShiroHttpServletRequest request = new ShiroHttpServletRequest(originalRequest, this.servletContext, true);
        String requestURI = this.loginContextService.getLocalelessPathWithinApplication();
        SecurityFilterChain chain = this.getMatchingChain(requestURI);
        this.requestGlobals.storeServletRequestResponse((HttpServletRequest)request, response);
        ThreadContext.bind((SecurityManager)this.securityManager);
        WebSubject subject = new WebSubject.Builder(this.securityManager, (ServletRequest)request, (ServletResponse)response).buildWebSubject();
        ThreadContext.bind((Subject)subject);
        try {
            if (chain == null) {
                boolean bl = handler.service((HttpServletRequest)request, response);
                return bl;
            }
            boolean handled = chain.getHandler().service((HttpServletRequest)request, response);
            boolean bl = handled || handler.service((HttpServletRequest)request, response);
            return bl;
        }
        finally {
            ThreadContext.remove((Object)subject);
            ThreadContext.remove();
        }
    }

    private SecurityFilterChain getMatchingChain(String requestURI) {
        for (SecurityFilterChain chain : this.chains) {
            if (!chain.matches(requestURI)) continue;
            return chain;
        }
        return null;
    }
}

