/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.security.internal.services.impl;

import java.io.IOException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.web.util.WebUtils;
import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.internal.services.LinkSource;
import org.apache.tapestry5.internal.services.RequestImpl;
import org.apache.tapestry5.internal.services.ResponseImpl;
import org.apache.tapestry5.internal.services.TapestrySessionFactory;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.services.ComponentEventLinkEncoder;
import org.apache.tapestry5.services.ComponentEventRequestParameters;
import org.apache.tapestry5.services.LocalizationSetter;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.RequestGlobals;
import org.apache.tapestry5.services.Response;
import org.tynamo.security.internal.services.LoginContextService;

public class LoginContextServiceImpl
implements LoginContextService {
    protected final String loginPage;
    protected final String defaultSuccessPage;
    protected final String unauthorizedPage;
    protected final HttpServletRequest servletRequest;
    protected final HttpServletResponse servletResponse;
    protected final ComponentEventLinkEncoder linkEncoder;
    protected final TapestrySessionFactory sessionFactory;
    protected final RequestGlobals requestGlobals;
    protected final String requestEncoding;
    private final LinkSource linkSource;
    private final LocalizationSetter localizationSetter;

    public LoginContextServiceImpl(@Inject @Symbol(value="security.successurl") String successUrl, @Inject @Symbol(value="security.loginurl") String loginUrl, @Inject @Symbol(value="security.unauthorizedurl") String unauthorizedUrl, @Inject @Symbol(value="tapestry.charset") String requestEncoding, HttpServletRequest serlvetRequest, HttpServletResponse servletResponse, LocalizationSetter localizationSetter, LinkSource linkSource, ComponentEventLinkEncoder linkEncoder, TapestrySessionFactory sessionFactory, RequestGlobals requestGlobals) {
        this.servletRequest = serlvetRequest;
        this.servletResponse = servletResponse;
        this.linkSource = linkSource;
        this.linkEncoder = linkEncoder;
        this.sessionFactory = sessionFactory;
        this.requestGlobals = requestGlobals;
        this.localizationSetter = localizationSetter;
        this.requestEncoding = requestEncoding;
        this.loginPage = LoginContextServiceImpl.urlToPage(loginUrl);
        this.defaultSuccessPage = LoginContextServiceImpl.urlToPage(successUrl);
        this.unauthorizedPage = LoginContextServiceImpl.urlToPage(unauthorizedUrl);
    }

    @Override
    public String getLoginPage() {
        return this.loginPage;
    }

    @Override
    public String getSuccessPage() {
        return this.defaultSuccessPage;
    }

    @Override
    public String getUnauthorizedPage() {
        return this.unauthorizedPage;
    }

    @Override
    public String getLoginURL() {
        return this.getLoginPage();
    }

    @Override
    public String getSuccessURL() {
        return this.getSuccessPage();
    }

    @Override
    public String getUnauthorizedURL() {
        return this.getUnauthorizedPage();
    }

    private static String urlToPage(String url) {
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        return url;
    }

    @Override
    public String getLocalelessPathWithinApplication() {
        String path = WebUtils.getPathWithinApplication((HttpServletRequest)this.servletRequest);
        String locale = this.getLocaleFromPath(path);
        return locale == null ? path : path.substring(locale.length() + 1);
    }

    @Override
    public String getLocaleFromPath(String path) {
        String[] split = path.substring(1).split("/");
        if (split.length > 1 && !"".equals(split[0])) {
            String possibleLocaleName = split[0];
            return this.localizationSetter.isSupportedLocaleName(possibleLocaleName) ? possibleLocaleName : null;
        }
        return null;
    }

    @Override
    public void removeSavedRequest() {
        Cookie cookie = new Cookie("shiroSavedRequest", null);
        cookie.setPath(this.getContextPath());
        cookie.setMaxAge(0);
        this.servletResponse.addCookie(cookie);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Cookie createSavedRequestCookie(String contextPath) {
        String requestUri;
        RequestImpl request = new RequestImpl(this.servletRequest, this.requestEncoding, this.sessionFactory);
        this.requestGlobals.storeRequestResponse((Request)request, (Response)new ResponseImpl(this.servletRequest, this.servletResponse));
        Cookie cookie = new Cookie("shiroSavedRequest", "");
        cookie.setPath(contextPath);
        if (!"GET".equalsIgnoreCase(this.servletRequest.getMethod())) {
            ComponentEventRequestParameters eventParameters = this.linkEncoder.decodeComponentEventRequest((Request)request);
            if (eventParameters == null) {
                cookie.setMaxAge(0);
                return cookie;
            }
            requestUri = this.createPageRenderLink(eventParameters);
        } else {
            ComponentEventRequestParameters eventParameters = this.linkEncoder.decodeComponentEventRequest((Request)request);
            if (eventParameters != null) {
                requestUri = this.createPageRenderLink(eventParameters);
            } else {
                requestUri = WebUtils.getRequestUri((HttpServletRequest)this.servletRequest);
                if (this.servletRequest.getQueryString() != null) {
                    requestUri = requestUri + "?" + this.servletRequest.getQueryString();
                }
            }
        }
        cookie.setValue(requestUri);
        return cookie;
    }

    private String createPageRenderLink(ComponentEventRequestParameters eventParameters) {
        EventContext eventContext = eventParameters.getPageActivationContext();
        Link link = this.linkSource.createPageRenderLink(eventParameters.getActivePageName(), true, (Object[])eventContext.toStrings());
        return link.toRedirectURI();
    }

    private String getContextPath() {
        String contextPath = this.servletRequest.getContextPath();
        if ("".equals(contextPath)) {
            contextPath = "/";
        }
        return contextPath;
    }

    @Override
    public void saveRequest() {
        this.servletResponse.addCookie(this.createSavedRequestCookie(this.getContextPath()));
    }

    @Override
    @Deprecated
    public void saveRequest(String contextPath) {
        this.servletResponse.addCookie(this.createSavedRequestCookie(contextPath));
    }

    @Override
    public void redirectToSavedRequest(String fallbackUrl) throws IOException {
        Cookie[] cookies = this.servletRequest.getCookies();
        String requestUri = null;
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!"shiroSavedRequest".equals(cookie.getName())) continue;
                requestUri = cookie.getValue();
                cookie.setMaxAge(0);
                this.servletResponse.addCookie(cookie);
                break;
            }
        }
        if (requestUri == null) {
            requestUri = fallbackUrl.startsWith(this.getContextPath()) ? fallbackUrl : this.getContextPath() + fallbackUrl;
        }
        this.servletResponse.setStatus(303);
        this.servletResponse.setHeader("Location", this.servletResponse.encodeRedirectURL(requestUri));
        this.servletResponse.flushBuffer();
    }
}

