/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.security.services.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Worker;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.slf4j.Logger;
import org.tynamo.security.services.SecurityFilterChainFactory;
import org.tynamo.security.services.SecurityFilterChainHub;
import org.tynamo.security.services.impl.SecurityFilterChain;
import org.tynamo.security.shiro.AccessControlFilter;

public class SecurityFilterChainHubImpl
implements SecurityFilterChainHub {
    private final Logger logger;
    private final SecurityFilterChainFactory factory;
    private final List<SecurityFilterChain> insertChains = CollectionFactory.newThreadSafeList();
    private final List<SecurityFilterChainConfig> updateChains = CollectionFactory.newThreadSafeList();
    private final List<String> removeChains = CollectionFactory.newThreadSafeList();

    public SecurityFilterChainHubImpl(Logger logger, SecurityFilterChainFactory factory) {
        this.logger = logger;
        this.factory = factory;
    }

    @Override
    public void insertChain(String path, AccessControlFilter filter, String config) {
        this.insertChains.add(this.factory.createChain(path).add(filter, config).build());
    }

    @Override
    public void updateChain(String path, AccessControlFilter filter, String config) {
        this.updateChains.add(new SecurityFilterChainConfig(path, filter, config));
    }

    @Override
    public void removeChain(String path) {
        this.removeChains.add(path);
    }

    @Override
    public void commitModifications(final Collection<SecurityFilterChain> chains) {
        final ArrayList chainsToRemove = new ArrayList();
        F.flow(this.updateChains).each((Worker)new Worker<SecurityFilterChainConfig>(){

            public void work(SecurityFilterChainConfig updateChainConfig) {
                try {
                    for (SecurityFilterChain chain : chains) {
                        if (!chain.getPath().equalsIgnoreCase(updateChainConfig.path)) continue;
                        chainsToRemove.add(chain);
                        SecurityFilterChainHubImpl.this.insertChains.add(SecurityFilterChainHubImpl.this.factory.createChain(updateChainConfig.path).add(updateChainConfig.filter, updateChainConfig.config).build());
                        break;
                    }
                }
                catch (RuntimeException ex) {
                    SecurityFilterChainHubImpl.this.logger.error(ex.getLocalizedMessage(), (Throwable)ex);
                }
            }
        });
        F.flow(this.insertChains).each((Worker)new Worker<SecurityFilterChain>(){

            public void work(SecurityFilterChain insertChain) {
                try {
                    chains.add(insertChain);
                }
                catch (RuntimeException ex) {
                    SecurityFilterChainHubImpl.this.logger.error(ex.getLocalizedMessage(), (Throwable)ex);
                }
            }
        });
        F.flow(this.removeChains).each((Worker)new Worker<String>(){

            public void work(String removeChain) {
                try {
                    for (SecurityFilterChain chain : chains) {
                        if (!chain.getPath().equalsIgnoreCase(removeChain)) continue;
                        chainsToRemove.add(chain);
                    }
                }
                catch (RuntimeException ex) {
                    SecurityFilterChainHubImpl.this.logger.error(ex.getLocalizedMessage(), (Throwable)ex);
                }
            }
        });
        this.insertChains.clear();
        this.updateChains.clear();
        this.removeChains.clear();
        chains.removeAll(chainsToRemove);
    }

    private class SecurityFilterChainConfig {
        private AccessControlFilter filter;
        private String path;
        private String config;

        public SecurityFilterChainConfig(String path, AccessControlFilter filter, String config) {
            this.path = path;
            this.filter = filter;
            this.config = config;
        }
    }
}

