/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.security.shiro;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.util.Collection;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.shiro.io.SerializationException;
import org.apache.shiro.io.Serializer;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;

public class SimplePrincipalSerializer
implements Serializer<PrincipalCollection> {
    private static final int MAGIC = 195935983;
    private final Collection<Class> knownPrincipalTypes;

    public SimplePrincipalSerializer(Collection<Class> knownPrincipalTypes) {
        this.knownPrincipalTypes = knownPrincipalTypes;
    }

    public byte[] serialize(PrincipalCollection pc) throws SerializationException {
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gout = new GZIPOutputStream(ba);
            ObjectOutputStream out = new ObjectOutputStream(gout);
            out.writeInt(195935983);
            out.writeShort(pc.getRealmNames().size());
            for (String realm : pc.getRealmNames()) {
                out.writeUTF(realm);
                Collection principals = pc.fromRealm(realm);
                out.writeShort(principals.size());
                for (Object principal : principals) {
                    out.writeObject(principal);
                }
            }
            gout.finish();
        }
        catch (IOException e) {
            throw new SerializationException(e.getMessage());
        }
        return ba.toByteArray();
    }

    public PrincipalCollection deserialize(byte[] serialized) throws SerializationException {
        ByteArrayInputStream ba = new ByteArrayInputStream(serialized);
        try {
            GZIPInputStream gin = new GZIPInputStream(ba);
            ObjectInputStream in = new ObjectInputStream(gin){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass osc) throws IOException, ClassNotFoundException {
                    Class<?> aClass = super.resolveClass(osc);
                    if (SimplePrincipalSerializer.this.knownPrincipalTypes.contains(aClass)) {
                        return aClass;
                    }
                    throw new SecurityException("Security violation: attempt to deserialize unauthorized " + aClass);
                }
            };
            SimplePrincipalCollection pc = new SimplePrincipalCollection();
            if (in.readInt() != 195935983) {
                throw new SerializationException("Not valid magic number while deserializing stored PrincipalCollection - possibly obsolete cookie.");
            }
            int numRealms = in.readShort();
            for (int i = 0; i < numRealms; ++i) {
                String realmName = in.readUTF();
                int numPrincipals = in.readShort();
                for (int j = 0; j < numPrincipals; ++j) {
                    Object principal = in.readObject();
                    pc.add(principal, realmName);
                }
            }
            return pc;
        }
        catch (IOException e) {
            throw new SerializationException(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new SerializationException(e.getMessage());
        }
    }
}

