/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.security;

import java.io.IOException;
import java.util.List;
import org.apache.tapestry5.services.ComponentClassResolver;
import org.apache.tapestry5.services.ComponentEventRequestParameters;
import org.apache.tapestry5.services.ComponentRequestFilter;
import org.apache.tapestry5.services.ComponentRequestHandler;
import org.apache.tapestry5.services.PageRenderRequestParameters;
import org.tynamo.security.internal.services.LoginContextService;
import org.tynamo.security.services.ClassInterceptorsCache;
import org.tynamo.shiro.extension.authz.aop.SecurityInterceptor;

public class SecurityComponentRequestFilter
implements ComponentRequestFilter {
    private final ComponentClassResolver resolver;
    private final ClassInterceptorsCache classInterceptorsCache;
    private final String loginClassName;
    private final String unauthorizedClassName;

    public SecurityComponentRequestFilter(LoginContextService loginContextService, ComponentClassResolver resolver, ClassInterceptorsCache classInterceptorsCache) {
        this.resolver = resolver;
        this.classInterceptorsCache = classInterceptorsCache;
        this.loginClassName = resolver.resolvePageNameToClassName(loginContextService.getLoginPage());
        this.unauthorizedClassName = resolver.resolvePageNameToClassName(loginContextService.getUnauthorizedPage());
    }

    public void handleComponentEvent(ComponentEventRequestParameters parameters, ComponentRequestHandler handler) throws IOException {
        this.checkInternal(parameters.getActivePageName());
        handler.handleComponentEvent(parameters);
    }

    public void handlePageRender(PageRenderRequestParameters parameters, ComponentRequestHandler handler) throws IOException {
        this.checkInternal(parameters.getLogicalPageName());
        handler.handlePageRender(parameters);
    }

    private void checkInternal(String logicalPageName) {
        List<SecurityInterceptor> interceptors;
        String pageClassName = this.resolver.resolvePageNameToClassName(logicalPageName);
        if (!pageClassName.equals(this.loginClassName) && !pageClassName.equals(this.unauthorizedClassName) && (interceptors = this.classInterceptorsCache.get(pageClassName)) != null) {
            for (SecurityInterceptor interceptor : interceptors) {
                interceptor.intercept();
            }
        }
    }
}

